/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.Objects;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.vms.Vm;

public class EdgeSwitch
extends AbstractSwitch {
    public static final int LEVEL = 2;
    public static final long DOWNLINK_BW = 800L;
    public static final int PORTS = 4;
    public static final double SWITCHING_DELAY = 0.00157;

    public EdgeSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setUplinkBandwidth(8.388608E8);
        this.setDownlinkBandwidth(800.0);
        this.setSwitchingDelay(0.00157);
        this.setPorts(4);
    }

    @Override
    protected void processPacketDown(SimEvent ev) {
        super.processPacketDown(ev);
        HostPacket netPkt = (HostPacket)ev.getData();
        Vm receiverVm = netPkt.getVmPacket().getDestination();
        NetworkHost host = this.getVmHost(receiverVm);
        netPkt.setDestination(host);
        this.addPacketToBeSentToHost(host, netPkt);
    }

    @Override
    protected void processPacketUp(SimEvent ev) {
        super.processPacketUp(ev);
        HostPacket hostPkt = (HostPacket)ev.getData();
        Vm receiverVm = hostPkt.getVmPacket().getDestination();
        NetworkHost host = this.getVmHost(receiverVm);
        hostPkt.setDestination(host);
        if (!Objects.isNull(host)) {
            this.addPacketToBeSentToHost(host, hostPkt);
            return;
        }
        Switch aggregateSwitch = this.getUplinkSwitches().get(0);
        this.addPacketToBeSentToUplinkSwitch(aggregateSwitch, hostPkt);
    }

    @Override
    public int getLevel() {
        return 2;
    }
}

