/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class RootSwitch
extends AbstractSwitch {
    public static final int LEVEL = 0;
    public static final int PORTS = 1;
    public static final double SWITCHING_DELAY = 0.00285;
    public static final long DOWNLINK_BW = 0x1400000000000L;

    public RootSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setDownlinkBandwidth(3.5184372088832E14);
        this.setSwitchingDelay(0.00285);
        this.setPorts(1);
    }

    @Override
    protected void processPacketUp(SimEvent ev) {
        super.processPacketUp(ev);
        HostPacket netPkt = (HostPacket)ev.getData();
        Vm receiverVm = netPkt.getVmPacket().getDestination();
        EdgeSwitch edgeSwitch = this.getVmEdgeSwitch(receiverVm);
        Switch aggSwitch = this.findAggregateSwitchConnectedToGivenEdgeSwitch(edgeSwitch);
        if (aggSwitch == Switch.NULL) {
            Log.printLine("No destination switch for this packet");
            return;
        }
        this.addPacketToBeSentToDownlinkSwitch(aggSwitch, netPkt);
    }

    private Switch findAggregateSwitchConnectedToGivenEdgeSwitch(Switch edgeSwitch) {
        for (Switch aggregateSw : this.getDownlinkSwitches()) {
            for (Switch edgeSw : aggregateSw.getDownlinkSwitches()) {
                if (edgeSw.getId() != edgeSwitch.getId()) continue;
                return aggregateSw;
            }
        }
        return Switch.NULL;
    }

    @Override
    public int getLevel() {
        return 0;
    }
}

