/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.network.DelayMatrix;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.network.topologies.TopologicalGraph;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;
import org.cloudbus.cloudsim.network.topologies.readers.TopologyReaderBrite;
import org.cloudbus.cloudsim.util.Log;

public class BriteNetworkTopology
implements NetworkTopology {
    private int nextIdx;
    private boolean networkEnabled;
    private DelayMatrix delayMatrix;
    private double[][] bwMatrix;
    private TopologicalGraph graph;
    private Map<Integer, Integer> map = new HashMap<Integer, Integer>();

    public BriteNetworkTopology() {
        this.bwMatrix = new double[0][0];
        this.graph = new TopologicalGraph();
        this.delayMatrix = new DelayMatrix();
    }

    public BriteNetworkTopology(String fileName) {
        this();
        Log.printConcatLine("Topology file: ", fileName);
        TopologyReaderBrite reader = new TopologyReaderBrite();
        try {
            this.graph = reader.readGraphFile(fileName);
            this.generateMatrices();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateMatrices() {
        this.delayMatrix = new DelayMatrix(this.getTopologycalGraph(), false);
        this.bwMatrix = this.createBwMatrix(this.getTopologycalGraph(), false);
        this.networkEnabled = true;
    }

    private double[][] createBwMatrix(TopologicalGraph graph, boolean directed) {
        int nodes = graph.getNumberOfNodes();
        double[][] mtx = new double[nodes][nodes];
        for (int i = 0; i < nodes; ++i) {
            for (int j = 0; j < nodes; ++j) {
                mtx[i][j] = 0.0;
            }
        }
        for (TopologicalLink edge : graph.getLinksList()) {
            mtx[edge.getSrcNodeID()][edge.getDestNodeID()] = edge.getLinkBw();
            if (directed) continue;
            mtx[edge.getDestNodeID()][edge.getSrcNodeID()] = edge.getLinkBw();
        }
        return mtx;
    }

    @Override
    public void addLink(int srcId, int destId, double bw, double lat) {
        if (Objects.isNull(this.getTopologycalGraph())) {
            this.graph = new TopologicalGraph();
        }
        if (Objects.isNull(this.map)) {
            this.map = new HashMap<Integer, Integer>();
        }
        if (!this.map.containsKey(srcId)) {
            this.getTopologycalGraph().addNode(new TopologicalNode(this.nextIdx));
            this.map.put(srcId, this.nextIdx);
            ++this.nextIdx;
        }
        if (!this.map.containsKey(destId)) {
            this.getTopologycalGraph().addNode(new TopologicalNode(this.nextIdx));
            this.map.put(destId, this.nextIdx);
            ++this.nextIdx;
        }
        this.getTopologycalGraph().addLink(new TopologicalLink(this.map.get(srcId), this.map.get(destId), (float)lat, (float)bw));
        this.generateMatrices();
    }

    @Override
    public void mapNode(int cloudSimEntityID, int briteID) {
        if (!this.networkEnabled) {
            return;
        }
        if (this.map.containsKey(cloudSimEntityID)) {
            Log.printConcatLine("Warning: Network mapping. CloudSim entity ", cloudSimEntityID, " already mapped.");
            return;
        }
        if (this.map.containsValue(briteID)) {
            Log.printConcatLine("Warning: BRITE node ", briteID, " already in use.");
            return;
        }
        this.map.put(cloudSimEntityID, briteID);
    }

    @Override
    public void unmapNode(int cloudSimEntityID) {
        if (!this.networkEnabled) {
            return;
        }
        this.map.remove(cloudSimEntityID);
    }

    @Override
    public double getDelay(int srcID, int destID) {
        if (!this.networkEnabled) {
            return 0.0;
        }
        try {
            return this.delayMatrix.getDelay(this.map.get(srcID), this.map.get(destID));
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    @Override
    public TopologicalGraph getTopologycalGraph() {
        return this.graph;
    }

    public double[][] getBwMatrix() {
        return (double[][])Arrays.copyOf(this.bwMatrix, this.bwMatrix.length);
    }
}

