/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies.readers;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.cloudbus.cloudsim.network.topologies.Point2D;
import org.cloudbus.cloudsim.network.topologies.TopologicalGraph;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;
import org.cloudbus.cloudsim.network.topologies.readers.TopologyReader;

public class TopologyReaderBrite
implements TopologyReader {
    private static final int PARSE_NOTHING = 0;
    private static final int PARSE_NODES = 1;
    private static final int PARSE_EDGES = 2;
    private int state = 0;
    private TopologicalGraph graph;

    @Override
    public TopologicalGraph readGraphFile(String filename) throws IOException {
        String nextLine;
        this.graph = new TopologicalGraph();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((nextLine = br.readLine()) != null) {
            if (this.state == 0) {
                if (!nextLine.contains("Nodes:")) continue;
                this.state = 1;
                continue;
            }
            if (this.state == 1) {
                this.parseNodeString(nextLine);
                continue;
            }
            if (this.state != 2) continue;
            this.parseEdgesString(nextLine);
        }
        br.close();
        return this.graph;
    }

    private void parseNodeString(String nodeLine) {
        if (nodeLine.contains("Edges:")) {
            this.state = 2;
            return;
        }
        Number[] parsedFields = new Integer[]{0, 0, 0};
        if (!this.parseLine(nodeLine, parsedFields, Integer::valueOf)) {
            return;
        }
        Point2D coordinates = new Point2D((Integer)parsedFields[1], (Integer)parsedFields[2]);
        TopologicalNode topoNode = new TopologicalNode((Integer)parsedFields[0], coordinates);
        this.graph.addNode(topoNode);
    }

    private void parseEdgesString(String nodeLine) {
        Number[] parsedFields = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        if (!this.parseLine(nodeLine, parsedFields, Double::valueOf)) {
            return;
        }
        int fromNode = ((Double)parsedFields[1]).intValue();
        int toNode = ((Double)parsedFields[2]).intValue();
        double linkDelay = (Double)parsedFields[4];
        double linkBandwidth = (Double)parsedFields[5];
        this.graph.addLink(new TopologicalLink(fromNode, toNode, linkDelay, linkBandwidth));
    }

    private <T extends Number> boolean parseLine(String nodeLine, T[] parsedFields, Function<String, T> castFunction) {
        StringTokenizer tokenizer = new StringTokenizer(nodeLine);
        if (!tokenizer.hasMoreElements()) {
            return false;
        }
        for (int i = 0; tokenizer.hasMoreElements() && i < parsedFields.length; ++i) {
            parsedFields[i] = (Number)castFunction.apply(tokenizer.nextToken());
        }
        return true;
    }
}

