/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import java.util.Objects;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.power.models.PowerModel;

public abstract class PowerModelAbstract
implements PowerModel {
    private PowerHost host;

    @Override
    public PowerHost getHost() {
        return this.host;
    }

    @Override
    public final void setHost(PowerHost host) {
        Objects.requireNonNull(host);
        this.host = host;
    }

    @Override
    public final double getPower(double utilization) throws IllegalArgumentException {
        if (utilization < 0.0 || utilization > 1.0) {
            throw new IllegalArgumentException(String.format("Utilization value must be between 0 and 1. The given value was %.2f", utilization));
        }
        if (this.getHost().getVmList().isEmpty() && !this.getHost().isActive()) {
            return 0.0;
        }
        return this.getPowerInternal(utilization);
    }

    protected abstract double getPowerInternal(double var1) throws IllegalArgumentException;
}

