/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import org.cloudbus.cloudsim.power.models.PowerModelAbstract;

public class PowerModelSquare
extends PowerModelAbstract {
    private double maxPower;
    private double constant;
    private double staticPower;

    public PowerModelSquare(double maxPower, double staticPowerPercent) {
        this.setMaxPower(maxPower);
        this.setStaticPower(staticPowerPercent * maxPower);
        this.setConstant((maxPower - this.getStaticPower()) / Math.pow(100.0, 2.0));
    }

    @Override
    protected double getPowerInternal(double utilization) throws IllegalArgumentException {
        if (utilization == 0.0) {
            return 0.0;
        }
        return this.getStaticPower() + this.getConstant() * Math.pow(utilization * 100.0, 2.0);
    }

    protected double getMaxPower() {
        return this.maxPower;
    }

    protected final void setMaxPower(double maxPower) {
        this.maxPower = maxPower;
    }

    protected double getConstant() {
        return this.constant;
    }

    protected final void setConstant(double constant) {
        this.constant = constant;
    }

    protected final double getStaticPower() {
        return this.staticPower;
    }

    protected final void setStaticPower(double staticPower) {
        this.staticPower = staticPower;
    }
}

