/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.provisioners;

import java.util.Objects;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerAbstract;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;

public class ResourceProvisionerSimple
extends ResourceProvisionerAbstract {
    public ResourceProvisionerSimple() {
        super(ResourceManageable.NULL);
    }

    protected ResourceProvisionerSimple(ResourceManageable resource) {
        super(resource);
    }

    @Override
    public boolean allocateResourceForVm(Vm vm, long newTotalVmResourceCapacity) {
        Objects.requireNonNull(vm);
        if (this.isSuitableForVm(vm, newTotalVmResourceCapacity)) {
            long prevVmResourceAllocation = vm.getResource(this.getResourceClass()).getAllocatedResource();
            if (this.getResourceAllocationMap().containsKey(vm)) {
                this.deallocateResourceForVm(vm);
            }
            if (!this.getResource().isObjectSubClassOf(Pe.class) && !vm.getResource(this.getResourceClass()).setCapacity(newTotalVmResourceCapacity)) {
                return false;
            }
            this.getResource().allocateResource(newTotalVmResourceCapacity);
            this.getResourceAllocationMap().put(vm, newTotalVmResourceCapacity);
            vm.getResource(this.getResourceClass()).setAllocatedResource(prevVmResourceAllocation);
            return true;
        }
        return false;
    }

    @Override
    public boolean allocateResourceForVm(Vm vm, double newTotalVmResource) {
        return this.allocateResourceForVm(vm, (long)newTotalVmResource);
    }

    @Override
    public boolean deallocateResourceForVm(Vm vm) {
        long amountFreed = this.deallocateResourceForVmSettingAllocationMapEntryToZero(vm);
        this.getResourceAllocationMap().remove(vm);
        return amountFreed > 0L;
    }

    @Override
    protected long deallocateResourceForVmSettingAllocationMapEntryToZero(Vm vm) {
        if (this.getResourceAllocationMap().containsKey(vm)) {
            long vmAllocatedResource = this.getResourceAllocationMap().get(vm);
            this.getResourceAllocationMap().put(vm, 0L);
            vm.deallocateResource(this.getResourceClass());
            this.getResource().deallocateResource(vmAllocatedResource);
            return vmAllocatedResource;
        }
        return 0L;
    }

    @Override
    public boolean isSuitableForVm(Vm vm, long newVmTotalAllocatedResource) {
        long currentAllocatedResource = this.getAllocatedResourceForVm(vm);
        long allocationDifference = newVmTotalAllocatedResource - currentAllocatedResource;
        return this.getResource().getAvailableResource() >= allocationDifference;
    }
}

