/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.Objects;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.resources.FileAttribute;

public class File {
    public static final int NOT_REGISTERED = -1;
    public static final int TYPE_UNKOWN = 0;
    public static final int TYPE_RAW_DATA = 1;
    public static final int TYPE_RECONSTRUCTED_DATA = 2;
    public static final int TYPE_TAG_DATA = 3;
    private String name;
    private Datacenter datacenter;
    private FileAttribute attribute;
    private double transactionTime;
    private boolean deleted;

    public File(String fileName, int fileSize) {
        this.init(fileName, fileSize);
    }

    public File(File file) throws IllegalArgumentException {
        if (Objects.isNull(file)) {
            throw new IllegalArgumentException("File(): Error - file is null.");
        }
        this.init(file.getName(), file.getSize());
        this.setDatacenter(file.getDatacenter());
        file.getFileAttribute().copyValue(this.attribute);
        this.attribute.setMasterCopy(false);
    }

    public static boolean isValid(String fileName) {
        return FileAttribute.isValid(fileName);
    }

    public static boolean isValid(File file) {
        return !Objects.isNull(file) && File.isValid(file.getName());
    }

    private void init(String fileName, int fileSize) throws IllegalArgumentException {
        if (fileSize <= 0) {
            throw new IllegalArgumentException("File(): Error - size <= 0.");
        }
        this.datacenter = Datacenter.NULL;
        this.setName(fileName);
        this.transactionTime = 0.0;
        this.createAttribute(fileSize);
    }

    private void createAttribute(int fileSize) {
        this.attribute = new FileAttribute(this, fileSize);
    }

    public File makeReplica() {
        return this.makeCopy();
    }

    public File makeMasterCopy() {
        File file = this.makeCopy();
        if (!Objects.isNull(file)) {
            file.setMasterCopy(true);
        }
        return file;
    }

    private File makeCopy() {
        File file = new File(this.name, this.attribute.getFileSize());
        this.attribute.copyValue(file.attribute);
        file.attribute.setMasterCopy(false);
        return file;
    }

    public FileAttribute getFileAttribute() {
        return this.attribute;
    }

    public int getAttributeSize() {
        return this.attribute.getAttributeSize();
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (!File.isValid(name)) {
            throw new IllegalArgumentException("File name cannot be null or empty");
        }
        this.name = name;
    }

    public boolean setOwnerName(String name) {
        return this.attribute.setOwnerName(name);
    }

    public String getOwnerName() {
        return this.attribute.getOwnerName();
    }

    public int getSize() {
        return this.attribute.getFileSize();
    }

    public int getSizeInByte() {
        return this.attribute.getFileSizeInByte();
    }

    public boolean setSize(int fileSize) {
        return this.attribute.setFileSize(fileSize);
    }

    public boolean setUpdateTime(double time) {
        return this.attribute.setUpdateTime(time);
    }

    public double getLastUpdateTime() {
        return this.attribute.getLastUpdateTime();
    }

    public boolean setRegistrationID(int id) {
        return this.attribute.setRegistrationId(id);
    }

    public int getRegistrationID() {
        return this.attribute.getRegistrationID();
    }

    public boolean setType(int type) {
        return this.attribute.setType(type);
    }

    public int getType() {
        return this.attribute.getType();
    }

    public boolean setChecksum(int checksum) {
        return this.attribute.setChecksum(checksum);
    }

    public int getChecksum() {
        return this.attribute.getChecksum();
    }

    public boolean setCost(double cost) {
        return this.attribute.setCost(cost);
    }

    public double getCost() {
        return this.attribute.getCost();
    }

    public long getCreationTime() {
        return this.attribute.getCreationTime();
    }

    public boolean isRegistered() {
        return this.attribute.isRegistered();
    }

    public boolean isMasterCopy() {
        return this.attribute.isMasterCopy();
    }

    public void setMasterCopy(boolean masterCopy) {
        this.attribute.setMasterCopy(masterCopy);
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean setTransactionTime(double time) {
        if (time < 0.0) {
            return false;
        }
        this.transactionTime = time;
        return true;
    }

    public double getTransactionTime() {
        return this.transactionTime;
    }

    public String toString() {
        return this.getName();
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    public final File setDatacenter(Datacenter datacenter) {
        if (Objects.isNull(datacenter)) {
            datacenter = Datacenter.NULL;
        }
        this.datacenter = datacenter;
        return this;
    }
}

