/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import org.cloudbus.cloudsim.resources.File;

public class FileAttribute {
    private String ownerName;
    private int id;
    private int type;
    private int fileSize;
    private int checksum;
    private double lastUpdateTime;
    private long creationTime;
    private double cost;
    private boolean masterCopy;
    private final File file;

    public FileAttribute(File file, int fileSize) {
        this.file = file;
        Calendar cal = !Objects.isNull(file.getDatacenter().getSimulation()) ? file.getDatacenter().getSimulation().getCalendar() : Calendar.getInstance();
        Date date = cal.getTime();
        this.creationTime = date.getTime();
        this.ownerName = "";
        this.id = -1;
        this.checksum = 0;
        this.type = 0;
        this.lastUpdateTime = 0.0;
        this.cost = 0.0;
        this.masterCopy = true;
        this.setFileSize(fileSize);
    }

    public boolean copyValue(FileAttribute destinationAttr) {
        if (Objects.isNull(destinationAttr)) {
            return false;
        }
        destinationAttr.setFileSize(this.fileSize);
        destinationAttr.setOwnerName(this.ownerName);
        destinationAttr.setUpdateTime(this.lastUpdateTime);
        destinationAttr.setRegistrationId(this.id);
        destinationAttr.setType(this.type);
        destinationAttr.setChecksum(this.checksum);
        destinationAttr.setCost(this.cost);
        destinationAttr.setMasterCopy(this.masterCopy);
        destinationAttr.setCreationTime(this.creationTime);
        return true;
    }

    public boolean setCreationTime(long creationTime) {
        if (creationTime <= 0L) {
            return false;
        }
        this.creationTime = creationTime;
        return true;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public boolean setOwnerName(String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            return false;
        }
        this.ownerName = name;
        return true;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getAttributeSize() {
        int length = 150000;
        if (!Objects.isNull(this.ownerName)) {
            length += this.ownerName.length();
        }
        return length += this.file.getName().length();
    }

    public final boolean setFileSize(int fileSize) {
        if (fileSize < 0) {
            return false;
        }
        this.fileSize = fileSize;
        return true;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getFileSizeInByte() {
        return this.fileSize * 1000000;
    }

    public boolean setUpdateTime(double time) {
        if (time <= 0.0 || time < this.lastUpdateTime) {
            return false;
        }
        this.lastUpdateTime = time;
        return true;
    }

    public double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public boolean setRegistrationId(int id) {
        if (id < 0) {
            return false;
        }
        this.id = id;
        return true;
    }

    public int getRegistrationID() {
        return this.id;
    }

    public boolean setType(int type) {
        if (type < 0) {
            return false;
        }
        this.type = type;
        return true;
    }

    public int getType() {
        return this.type;
    }

    public boolean setChecksum(int checksum) {
        if (checksum < 0) {
            return false;
        }
        this.checksum = checksum;
        return true;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public boolean setCost(double cost) {
        if (cost < 0.0) {
            return false;
        }
        this.cost = cost;
        return true;
    }

    public double getCost() {
        return this.cost;
    }

    public boolean isRegistered() {
        return this.id != -1;
    }

    public void setMasterCopy(boolean masterCopy) {
        this.masterCopy = masterCopy;
    }

    public boolean isMasterCopy() {
        return this.masterCopy;
    }

    public static boolean isValid(String fileName) {
        return !Objects.isNull(fileName) && !fileName.trim().isEmpty();
    }
}

