/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.Objects;
import org.cloudbus.cloudsim.provisioners.PeProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.ResourceManageableAbstract;

public class PeSimple
extends ResourceManageableAbstract
implements Pe {
    private int id;
    private Pe.Status status;
    private PeProvisioner peProvisioner;

    public PeSimple(double mipsCapacity, PeProvisioner peProvisioner) {
        super((long)mipsCapacity);
        this.setId(-1);
        this.setPeProvisioner(peProvisioner);
        this.setStatus(Pe.Status.FREE);
    }

    public PeSimple(int id, double mipsCapacity, PeProvisioner peProvisioner) {
        this(mipsCapacity, peProvisioner);
        this.setId(id);
    }

    @Override
    public final void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Pe.Status getStatus() {
        return this.status;
    }

    @Override
    public final boolean setStatus(Pe.Status status) {
        this.status = status;
        return true;
    }

    @Override
    public boolean setCapacity(double mipsCapacity) {
        return this.setCapacity((long)mipsCapacity);
    }

    @Override
    public final Pe setPeProvisioner(PeProvisioner peProvisioner) {
        Objects.requireNonNull(peProvisioner);
        this.peProvisioner = peProvisioner;
        this.peProvisioner.setPe(this);
        return this;
    }

    @Override
    public PeProvisioner getPeProvisioner() {
        return this.peProvisioner;
    }

    @Override
    public String toString() {
        return String.valueOf(this.getId());
    }

    @Override
    public boolean isWorking() {
        return !this.isFailed();
    }

    @Override
    public boolean isFailed() {
        return Pe.Status.FAILED.equals((Object)this.status);
    }

    @Override
    public boolean isFree() {
        return Pe.Status.FREE.equals((Object)this.status);
    }

    @Override
    public boolean isBuzy() {
        return Pe.Status.BUSY.equals((Object)this.status);
    }
}

