/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.cloudbus.cloudsim.resources.ResourceAbstract;
import org.cloudbus.cloudsim.resources.ResourceManageable;

public abstract class ResourceManageableAbstract
extends ResourceAbstract
implements ResourceManageable {
    private long availableResource;

    public ResourceManageableAbstract(long capacity) {
        super(capacity);
        this.availableResource = capacity;
    }

    @Override
    public boolean setCapacity(long newCapacity) {
        if (newCapacity < 0L || this.getAllocatedResource() > newCapacity) {
            return false;
        }
        long oldCapacity = this.capacity;
        this.capacity = newCapacity;
        this.sumAvailableResource(newCapacity - oldCapacity);
        return true;
    }

    @Override
    public boolean addCapacity(long capacityToAdd) {
        if (capacityToAdd < 0L) {
            throw new IllegalArgumentException("The number of PEs to add cannot be negative.");
        }
        return this.setCapacity(this.getCapacity() + capacityToAdd);
    }

    @Override
    public boolean removeCapacity(long capacityToRemove) {
        if (capacityToRemove < 0L) {
            throw new IllegalArgumentException("The number of PEs to remove cannot be negative.");
        }
        if (capacityToRemove > this.getCapacity()) {
            throw new IllegalArgumentException("The number of PEs to remove cannot be higher than the number of existing PEs. Requested to remove: " + capacityToRemove + " PEs. Existing: " + this.getCapacity() + " PEs.");
        }
        return this.setCapacity(this.getCapacity() - capacityToRemove);
    }

    protected boolean sumAvailableResource(long amountToSum) {
        long newTotalAvailableResource = this.getAvailableResource() + amountToSum;
        return this.setAvailableResource(newTotalAvailableResource);
    }

    protected final boolean setAvailableResource(long newAvailableResource) {
        if (newAvailableResource < 0L || newAvailableResource > this.getCapacity()) {
            return false;
        }
        this.availableResource = newAvailableResource;
        return true;
    }

    @Override
    public long getAvailableResource() {
        return this.availableResource;
    }

    @Override
    public boolean allocateResource(long amountToAllocate) {
        if (amountToAllocate <= 0L || !this.isResourceAmountAvailable(amountToAllocate)) {
            return false;
        }
        long newAvailableResource = this.getAvailableResource() - amountToAllocate;
        return this.setAvailableResource(newAvailableResource);
    }

    @Override
    public boolean setAllocatedResource(long newTotalAllocatedResource) {
        if (newTotalAllocatedResource < 0L || !this.isSuitable(newTotalAllocatedResource)) {
            return false;
        }
        this.deallocateAllResources();
        return this.allocateResource(newTotalAllocatedResource);
    }

    @Override
    public boolean deallocateAndRemoveResource(long amountToDeallocate) {
        long amountToRemoveFromSize = amountToDeallocate;
        if ((amountToDeallocate = Math.min(amountToDeallocate, this.getAllocatedResource())) != 0L && !this.deallocateResource(amountToDeallocate)) {
            return false;
        }
        return this.removeCapacity(amountToRemoveFromSize);
    }

    @Override
    public boolean deallocateResource(long amountToDeallocate) {
        if (amountToDeallocate <= 0L || !this.isResourceAmountBeingUsed(amountToDeallocate)) {
            return false;
        }
        long newAvailableResource = this.getAvailableResource() + amountToDeallocate;
        return this.setAvailableResource(newAvailableResource);
    }

    @Override
    public long deallocateAllResources() {
        long previousAllocated = this.getAllocatedResource();
        this.setAvailableResource(this.getCapacity());
        return previousAllocated;
    }

    public String toString() {
        return String.format("%s: used %d of %d", this.getClass().getSimpleName(), this.getAllocatedResource(), this.getCapacity());
    }
}

