/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.cloudbus.cloudsim.resources.File;
import org.cloudbus.cloudsim.resources.HarddriveStorage;

public class SanStorage
extends HarddriveStorage {
    private final double bandwidth;
    private final double networkLatency;

    public SanStorage(long capacity, double bandwidth, double networkLatency) throws IllegalArgumentException {
        super(capacity);
        this.bandwidth = bandwidth;
        this.networkLatency = networkLatency;
    }

    public SanStorage(String name, long capacity, double bandwidth, double networkLatency) {
        super(name, capacity);
        this.bandwidth = bandwidth;
        this.networkLatency = networkLatency;
    }

    @Override
    public double addReservedFile(File file) {
        double time = super.addReservedFile(file);
        return time + this.getFileTransferTimePlusNetworkLatency(file);
    }

    @Override
    public double getMaxTransferRate() {
        double diskRate = super.getMaxTransferRate();
        return Math.min(diskRate, this.getBandwidth());
    }

    @Override
    public double addFile(File file) {
        double time = super.addFile(file);
        if (time > 0.0) {
            return time + this.getFileTransferTimePlusNetworkLatency(file);
        }
        return time;
    }

    private double getFileTransferTimePlusNetworkLatency(File file) {
        return (double)file.getSize() * this.getBandwidth() + this.getNetworkLatency();
    }

    @Override
    public double deleteFile(File file) {
        double time = super.deleteFile(file);
        return time + this.getFileTransferTimePlusNetworkLatency(file);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public double getNetworkLatency() {
        return this.networkLatency;
    }
}

