/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.cloudlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletExecution;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.PacketScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class CloudletSchedulerAbstract
implements CloudletScheduler {
    private final List<CloudletExecution> cloudletPausedList;
    private final List<CloudletExecution> cloudletFinishedList;
    private final List<CloudletExecution> cloudletFailedList;
    private PacketScheduler packetScheduler;
    private int usedPes;
    private double previousTime;
    private List<Double> currentMipsShare;
    private List<CloudletExecution> cloudletExecList;
    private final List<CloudletExecution> cloudletWaitingList;
    private Vm vm;
    private Set<Cloudlet> cloudletReturnedList;

    public CloudletSchedulerAbstract() {
        this.setPreviousTime(0.0);
        this.usedPes = 0;
        this.vm = Vm.NULL;
        this.cloudletExecList = new ArrayList<CloudletExecution>();
        this.cloudletPausedList = new ArrayList<CloudletExecution>();
        this.cloudletFinishedList = new ArrayList<CloudletExecution>();
        this.cloudletFailedList = new ArrayList<CloudletExecution>();
        this.cloudletWaitingList = new ArrayList<CloudletExecution>();
        this.cloudletReturnedList = new HashSet<Cloudlet>();
        this.currentMipsShare = new ArrayList<Double>();
        this.packetScheduler = PacketScheduler.NULL;
    }

    @Override
    public double getPreviousTime() {
        return this.previousTime;
    }

    protected final void setPreviousTime(double previousTime) {
        this.previousTime = previousTime;
    }

    @Override
    public List<Double> getCurrentMipsShare() {
        return Collections.unmodifiableList(this.currentMipsShare);
    }

    protected void setCurrentMipsShare(List<Double> currentMipsShare) {
        if ((long)currentMipsShare.size() > this.vm.getNumberOfPes()) {
            Log.printFormattedLine("Requested %d PEs but %s has just %d", currentMipsShare.size(), this.vm, this.vm.getNumberOfPes());
        }
        this.currentMipsShare = currentMipsShare;
    }

    public double getAvailableMipsByPe() {
        long totalPesOfAllExecCloudlets = this.totalPesOfAllExecCloudlets();
        if (totalPesOfAllExecCloudlets > (long)this.currentMipsShare.size()) {
            return this.getTotalMipsShare() / (double)totalPesOfAllExecCloudlets;
        }
        return this.getPeCapacity();
    }

    private Double getPeCapacity() {
        return this.currentMipsShare.stream().findFirst().orElse(0.0);
    }

    private long totalPesOfAllExecCloudlets() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToLong(Cloudlet::getNumberOfPes).sum();
    }

    private double getTotalMipsShare() {
        return this.currentMipsShare.stream().reduce(0.0, Double::sum);
    }

    @Override
    public List<CloudletExecution> getCloudletExecList() {
        return Collections.unmodifiableList(this.cloudletExecList);
    }

    protected void addCloudletToWaitingList(CloudletExecution cloudlet) {
        if (cloudlet == null || CloudletExecution.NULL.equals(cloudlet)) {
            return;
        }
        cloudlet.setCloudletStatus(Cloudlet.Status.QUEUED);
        this.cloudletWaitingList.add(cloudlet);
    }

    protected List<CloudletExecution> getCloudletPausedList() {
        return this.cloudletPausedList;
    }

    @Override
    public List<CloudletExecution> getCloudletFinishedList() {
        return this.cloudletFinishedList;
    }

    protected void addCloudletToFinishedList(CloudletExecution cloudlet) {
        this.cloudletFinishedList.add(cloudlet);
    }

    protected List<CloudletExecution> getCloudletFailedList() {
        return this.cloudletFailedList;
    }

    @Override
    public List<CloudletExecution> getCloudletWaitingList() {
        return Collections.unmodifiableList(this.cloudletWaitingList);
    }

    protected void sortCloudletWaitingList(Comparator<CloudletExecution> comparator) {
        this.cloudletWaitingList.sort(comparator);
    }

    @Override
    public double cloudletSubmit(Cloudlet cloudlet) {
        return this.cloudletSubmit(cloudlet, 0.0);
    }

    @Override
    public double cloudletSubmit(Cloudlet cl, double fileTransferTime) {
        return this.processCloudletSubmit(new CloudletExecution(cl), fileTransferTime);
    }

    protected double processCloudletSubmit(CloudletExecution rcl, double fileTransferTime) {
        if (this.canAddCloudletToExecutionList(rcl)) {
            rcl.setCloudletStatus(Cloudlet.Status.INEXEC);
            rcl.setFileTransferTime(fileTransferTime);
            this.addCloudletToExecList(rcl);
            return fileTransferTime + (double)rcl.getCloudletLength() / this.getPeCapacity();
        }
        this.addCloudletToWaitingList(rcl);
        return 0.0;
    }

    protected void addCloudletToExecList(CloudletExecution cloudlet) {
        cloudlet.setCloudletStatus(Cloudlet.Status.INEXEC);
        cloudlet.setLastProcessingTime(this.getVm().getSimulation().clock());
        this.cloudletExecList.add(cloudlet);
        this.addUsedPes(cloudlet.getNumberOfPes());
    }

    @Override
    public boolean hasFinishedCloudlets() {
        return !this.cloudletFinishedList.isEmpty();
    }

    @Override
    public int runningCloudletsNumber() {
        return this.cloudletExecList.size();
    }

    @Override
    public Cloudlet getCloudletToMigrate() {
        Function<CloudletExecution, Cloudlet> finishCloudletMigration = rcl -> {
            this.removeCloudletFromExecListAndAddToFinishedList((CloudletExecution)rcl);
            rcl.finalizeCloudlet();
            return rcl.getCloudlet();
        };
        return this.cloudletExecList.stream().findFirst().map(finishCloudletMigration).orElse(Cloudlet.NULL);
    }

    @Override
    public int getCloudletStatus(int cloudletId) {
        Optional<CloudletExecution> optional = this.findCloudletInAllLists(cloudletId);
        return optional.map(CloudletExecution::getCloudlet).map(Cloudlet::getStatus).map(Enum::ordinal).orElse(-1);
    }

    protected Optional<CloudletExecution> findCloudletInAllLists(double cloudletId) {
        Stream<List> streamOfAllLists = Stream.of(this.cloudletExecList, this.cloudletPausedList, this.cloudletWaitingList, this.cloudletFinishedList, this.cloudletFailedList);
        return streamOfAllLists.flatMap(Collection::stream).filter(c -> (double)c.getCloudletId() == cloudletId).findFirst();
    }

    protected Optional<CloudletExecution> findCloudletInList(double cloudletId, List<CloudletExecution> list) {
        return list.stream().filter(rcl -> (double)rcl.getCloudletId() == cloudletId).findFirst();
    }

    @Override
    public void cloudletFinish(CloudletExecution rcl) {
        rcl.setCloudletStatus(Cloudlet.Status.SUCCESS);
        rcl.finalizeCloudlet();
        this.addCloudletToFinishedList(rcl);
    }

    @Override
    public boolean cloudletPause(int cloudletId) {
        if (this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudletId, c -> this.changeStatusOfCloudlet((CloudletExecution)c, Cloudlet.Status.INEXEC, Cloudlet.Status.PAUSED)) != Cloudlet.NULL) {
            return true;
        }
        return this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudletId, c -> this.changeStatusOfCloudlet((CloudletExecution)c, Cloudlet.Status.READY, Cloudlet.Status.PAUSED)) != Cloudlet.NULL;
    }

    @Override
    public Cloudlet cloudletCancel(int cloudletId) {
        Cloudlet cloudlet = this.changeStatusOfCloudletIntoList(this.cloudletFinishedList, cloudletId, c -> {});
        if (cloudlet != Cloudlet.NULL) {
            return cloudlet;
        }
        cloudlet = this.changeStatusOfCloudletIntoList(this.cloudletExecList, cloudletId, c -> this.changeStatusOfCloudlet((CloudletExecution)c, Cloudlet.Status.INEXEC, Cloudlet.Status.CANCELED));
        if (cloudlet != Cloudlet.NULL) {
            return cloudlet;
        }
        cloudlet = this.changeStatusOfCloudletIntoList(this.cloudletPausedList, cloudletId, c -> this.changeStatusOfCloudlet((CloudletExecution)c, Cloudlet.Status.PAUSED, Cloudlet.Status.CANCELED));
        if (cloudlet != Cloudlet.NULL) {
            return cloudlet;
        }
        cloudlet = this.changeStatusOfCloudletIntoList(this.cloudletWaitingList, cloudletId, c -> this.changeStatusOfCloudlet((CloudletExecution)c, Cloudlet.Status.READY, Cloudlet.Status.CANCELED));
        if (cloudlet != Cloudlet.NULL) {
            return cloudlet;
        }
        return Cloudlet.NULL;
    }

    private void changeStatusOfCloudlet(CloudletExecution cloudlet, Cloudlet.Status currentStatus, Cloudlet.Status newStatus) {
        if ((currentStatus == Cloudlet.Status.INEXEC || currentStatus == Cloudlet.Status.READY) && cloudlet.getCloudlet().isFinished()) {
            this.cloudletFinish(cloudlet);
        } else {
            cloudlet.setCloudletStatus(newStatus);
        }
        switch (newStatus) {
            case PAUSED: {
                this.cloudletPausedList.add(cloudlet);
            }
        }
    }

    private Cloudlet changeStatusOfCloudletIntoList(List<CloudletExecution> cloudletList, int cloudletId, Consumer<CloudletExecution> cloudletStatusUpdaterConsumer) {
        Function<CloudletExecution, Cloudlet> removeCloudletFromListAndUpdateItsStatus = c -> {
            cloudletList.remove(c);
            cloudletStatusUpdaterConsumer.accept((CloudletExecution)c);
            return c.getCloudlet();
        };
        return cloudletList.stream().filter(c -> c.getCloudlet().getId() == cloudletId).findFirst().map(removeCloudletFromListAndUpdateItsStatus).orElse(Cloudlet.NULL);
    }

    @Override
    public double updateProcessing(double currentTime, List<Double> mipsShare) {
        this.setCurrentMipsShare(mipsShare);
        if (this.cloudletExecList.isEmpty() && this.cloudletWaitingList.isEmpty()) {
            this.setPreviousTime(currentTime);
            return Double.MAX_VALUE;
        }
        this.updateCloudletsProcessing(currentTime);
        this.updateVmRamAbsoluteUtilization();
        this.removeFinishedCloudletsFromExecutionListAndAddToFinishedList();
        this.moveNextCloudletsFromWaitingToExecList();
        double nextSimulationTime = this.getEstimatedFinishTimeOfSoonerFinishingCloudlet(currentTime);
        this.setPreviousTime(currentTime);
        return nextSimulationTime;
    }

    private void updateCloudletsProcessing(double currentTime) {
        for (CloudletExecution rcl : this.cloudletExecList) {
            this.updateCloudletProcessingAndPacketsDispatch(rcl, currentTime);
        }
    }

    private void updateCloudletProcessingAndPacketsDispatch(CloudletExecution rcl, double currentTime) {
        if (this.packetScheduler.isTimeToUpdateCloudletProcessing(rcl.getCloudlet())) {
            this.updateCloudletProcessing(rcl, currentTime);
        }
        this.packetScheduler.processCloudletPackets(rcl.getCloudlet(), currentTime);
    }

    protected void updateCloudletProcessing(CloudletExecution rcl, double currentTime) {
        long executedInstructions = this.cloudletExecutedInstructionsForElapsedTime(rcl, currentTime);
        rcl.updateProcessing(executedInstructions);
    }

    private void updateVmRamAbsoluteUtilization() {
        ResourceManageable ram = this.vm.getResource(Ram.class);
        double totalUsedRam = this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(this::getCloudletRamAbsoluteUtilization).sum();
        ram.setAllocatedResource(totalUsedRam);
    }

    private double getCloudletRamAbsoluteUtilization(Cloudlet cloudlet) {
        ResourceManageable ram = this.vm.getResource(Ram.class);
        UtilizationModel um = cloudlet.getUtilizationModelRam();
        double utilization = um.getUnit() == UtilizationModel.Unit.ABSOLUTE ? Math.min(um.getUtilization(), (double)this.vm.getRam().getCapacity()) : um.getUtilization() * (double)ram.getCapacity();
        return utilization;
    }

    private long cloudletExecutedInstructionsForElapsedTime(CloudletExecution cl, double currentTime) {
        double actualProcessingTime = this.hasCloudletFileTransferTimePassed(cl, currentTime) ? this.timeSpan(cl, currentTime) : 0.0;
        double cloudletUsedMips = this.getAbsoluteCloudletResourceUtilization(cl.getCloudlet().getUtilizationModelCpu(), currentTime, this.getAvailableMipsByPe());
        return (long)(cloudletUsedMips * actualProcessingTime * 1000000.0);
    }

    private boolean hasCloudletFileTransferTimePassed(CloudletExecution rcl, double currentTime) {
        return rcl.getFileTransferTime() == 0.0 || currentTime - rcl.getCloudletArrivalTime() > rcl.getFileTransferTime() || rcl.getCloudlet().getFinishedLengthSoFar() > 0L;
    }

    protected double timeSpan(CloudletExecution cl, double currentTime) {
        return currentTime - cl.getLastProcessingTime();
    }

    private int removeFinishedCloudletsFromExecutionListAndAddToFinishedList() {
        List finishedCloudlets = this.cloudletExecList.stream().filter(c -> c.getCloudlet().isFinished()).collect(Collectors.toList());
        for (CloudletExecution c2 : finishedCloudlets) {
            this.removeCloudletFromExecListAndAddToFinishedList(c2);
        }
        return finishedCloudlets.size();
    }

    private void removeCloudletFromExecListAndAddToFinishedList(CloudletExecution cloudlet) {
        this.setCloudletFinishTimeAndAddToFinishedList(cloudlet);
        this.removeCloudletFromExecList(cloudlet);
    }

    protected CloudletExecution removeCloudletFromExecList(CloudletExecution cloudlet) {
        this.removeUsedPes(cloudlet.getNumberOfPes());
        return this.cloudletExecList.remove(cloudlet) ? cloudlet : CloudletExecution.NULL;
    }

    private void setCloudletFinishTimeAndAddToFinishedList(CloudletExecution rcl) {
        double clock = this.vm.getSimulation().clock();
        rcl.setFinishTime(clock);
        this.cloudletFinish(rcl);
    }

    protected double getEstimatedFinishTimeOfSoonerFinishingCloudlet(double currentTime) {
        return this.cloudletExecList.stream().mapToDouble(c -> this.getEstimatedFinishTimeOfCloudlet((CloudletExecution)c, currentTime)).min().orElse(Double.MAX_VALUE);
    }

    protected double getEstimatedFinishTimeOfCloudlet(CloudletExecution rcl, double currentTime) {
        double cloudletUsedMips = this.getAbsoluteCloudletResourceUtilization(rcl.getCloudlet().getUtilizationModelCpu(), currentTime, this.getAvailableMipsByPe());
        double estimatedFinishTime = (double)rcl.getRemainingCloudletLength() / cloudletUsedMips;
        if (estimatedFinishTime < this.vm.getSimulation().getMinTimeBetweenEvents()) {
            estimatedFinishTime = this.vm.getSimulation().getMinTimeBetweenEvents();
        }
        return estimatedFinishTime;
    }

    protected void moveNextCloudletsFromWaitingToExecList() {
        Optional<CloudletExecution> optional = Optional.of(CloudletExecution.NULL);
        while (!this.cloudletWaitingList.isEmpty() && optional.isPresent() && this.getFreePes() > 0L) {
            optional = this.findSuitableWaitingCloudlet();
            optional.ifPresent(this::addWaitingCloudletToExecList);
        }
    }

    protected Optional<CloudletExecution> findSuitableWaitingCloudlet() {
        return this.cloudletWaitingList.stream().filter(this::isThereEnoughFreePesForCloudlet).findFirst();
    }

    protected boolean isThereEnoughFreePesForCloudlet(CloudletExecution c) {
        return (long)(this.currentMipsShare.size() - this.usedPes) >= c.getNumberOfPes();
    }

    protected CloudletExecution addWaitingCloudletToExecList(CloudletExecution cloudlet) {
        this.cloudletWaitingList.remove(cloudlet);
        this.addCloudletToExecList(cloudlet);
        return cloudlet;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public void setVm(Vm vm) {
        Objects.requireNonNull(vm);
        if (this.isOtherVmAssigned(vm)) {
            throw new IllegalArgumentException("CloudletScheduler already has a Vm assigned to it. Each Vm must have its own CloudletScheduler instance.");
        }
        this.vm = vm;
    }

    private boolean isOtherVmAssigned(Vm vm) {
        return !Objects.isNull(this.vm) && this.vm != Vm.NULL && !vm.equals(this.vm);
    }

    @Override
    public long getUsedPes() {
        return this.usedPes;
    }

    @Override
    public long getFreePes() {
        return this.currentMipsShare.size() - this.usedPes;
    }

    private void addUsedPes(long usedPesToAdd) {
        this.usedPes = (int)((long)this.usedPes + usedPesToAdd);
    }

    private void removeUsedPes(long usedPesToRemove) {
        this.usedPes = (int)Math.max(0L, (long)this.usedPes - usedPesToRemove);
    }

    @Override
    public PacketScheduler getPacketScheduler() {
        return this.packetScheduler;
    }

    @Override
    public void setPacketScheduler(PacketScheduler packetScheduler) {
        this.packetScheduler = Objects.isNull(packetScheduler) ? PacketScheduler.NULL : packetScheduler;
        this.packetScheduler.setVm(this.vm);
    }

    @Override
    public boolean isTherePacketScheduler() {
        return !Objects.isNull(this.packetScheduler) && this.packetScheduler != PacketScheduler.NULL;
    }

    @Override
    public double getRequestedCpuPercentUtilization(double time) {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).mapToDouble(c -> this.getAbsoluteCloudletCpuUtilizationForAllPes(time, (Cloudlet)c)).sum() / this.vm.getTotalMipsCapacity();
    }

    private double getAbsoluteCloudletCpuUtilizationForAllPes(double time, Cloudlet cloudlet) {
        double cloudletCpuUsageForOnePe = this.getAbsoluteCloudletResourceUtilization(cloudlet.getUtilizationModelCpu(), time, this.getAvailableMipsByPe());
        return cloudletCpuUsageForOnePe * (double)cloudlet.getNumberOfPes();
    }

    @Override
    public double getRequestedMipsForCloudlet(CloudletExecution rcl, double time) {
        return this.getAbsoluteCloudletResourceUtilization(rcl.getCloudlet().getUtilizationModelCpu(), time, this.vm.getMips());
    }

    @Override
    public double getAllocatedMipsForCloudlet(CloudletExecution rcl, double time) {
        return this.getAbsoluteCloudletResourceUtilization(rcl.getCloudlet().getUtilizationModelCpu(), time, this.getAvailableMipsByPe());
    }

    @Override
    public double getCurrentRequestedBwPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).map(Cloudlet::getUtilizationModelBw).mapToDouble(um -> this.getAbsoluteCloudletResourceUtilization((UtilizationModel)um, this.vm.getBw().getCapacity())).sum() / (double)this.vm.getBw().getCapacity();
    }

    @Override
    public double getCurrentRequestedRamPercentUtilization() {
        return this.cloudletExecList.stream().map(CloudletExecution::getCloudlet).map(Cloudlet::getUtilizationModelRam).mapToDouble(um -> this.getAbsoluteCloudletResourceUtilization((UtilizationModel)um, this.vm.getRam().getCapacity())).sum() / (double)this.vm.getRam().getCapacity();
    }

    private double getAbsoluteCloudletResourceUtilization(UtilizationModel um, double maxResourceAllowedToUse) {
        return this.getAbsoluteCloudletResourceUtilization(um, this.vm.getSimulation().clock(), maxResourceAllowedToUse);
    }

    private double getAbsoluteCloudletResourceUtilization(UtilizationModel um, double time, double maxResourceAllowedToUse) {
        return um.getUnit() == UtilizationModel.Unit.ABSOLUTE ? Math.min(um.getUtilization(time), maxResourceAllowedToUse) : um.getUtilization() * maxResourceAllowedToUse;
    }

    @Override
    public Set<Cloudlet> getCloudletReturnedList() {
        return Collections.unmodifiableSet(this.cloudletReturnedList);
    }

    @Override
    public boolean isCloudletReturned(Cloudlet cloudlet) {
        return this.cloudletReturnedList.contains(cloudlet);
    }

    @Override
    public void addCloudletToReturnedList(Cloudlet cloudlet) {
        this.cloudletReturnedList.add(cloudlet);
    }

    @Override
    public void deallocatePesFromVm(Vm vm, int pesToRemove) {
        this.removeUsedPes(pesToRemove);
        this.deallocatePesFromMipsShare(pesToRemove);
    }

    private void deallocatePesFromMipsShare(int pesToRemove) {
        pesToRemove = Math.min(pesToRemove, this.currentMipsShare.size());
        IntStream.range(0, pesToRemove).forEach(i -> this.currentMipsShare.remove(0));
    }

    @Override
    public List<Cloudlet> getCloudletList() {
        return Stream.concat(this.cloudletExecList.stream(), this.cloudletWaitingList.stream()).map(CloudletExecution::getCloudlet).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Override
    public boolean isEmpty() {
        return this.getCloudletList().isEmpty();
    }
}

