/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.cloudlet;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.cloudlets.CloudletExecution;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletSchedulerTimeShared;
import org.cloudbus.cloudsim.util.MathUtil;

public final class CloudletSchedulerCompletelyFair
extends CloudletSchedulerTimeShared {
    private int minimumGranularity = 2;
    private int latency = 3;

    private int waitingCloudletsComparator(CloudletExecution c1, CloudletExecution c2) {
        double vRuntimeDiff = c1.getVirtualRuntime() - c2.getVirtualRuntime();
        int priorityDiff = c1.getCloudlet().getPriority() - c2.getCloudlet().getPriority();
        if (vRuntimeDiff != 0.0) {
            return MathUtil.doubleToInt(vRuntimeDiff);
        }
        int idDiff = c1.getCloudletId() - c2.getCloudletId();
        return priorityDiff == 0 ? idDiff : priorityDiff;
    }

    public int getLatency() {
        return this.latency;
    }

    public void setLatency(int latency) {
        if (latency < this.minimumGranularity) {
            throw new IllegalArgumentException("Latency cannot be lower than the mininum granularity.");
        }
        this.latency = latency;
    }

    protected double computeCloudletTimeSlice(CloudletExecution cloudlet) {
        double timeslice = (double)this.getLatency() * this.getCloudletWeightPercentBetweenAllCloudlets(cloudlet);
        return Math.min(timeslice, (double)this.getMinimumGranularity());
    }

    @Override
    public List<CloudletExecution> getCloudletWaitingList() {
        return super.getCloudletWaitingList();
    }

    @Override
    protected Optional<CloudletExecution> findSuitableWaitingCloudlet() {
        this.sortCloudletWaitingList(this::waitingCloudletsComparator);
        return super.findSuitableWaitingCloudlet();
    }

    protected double getCloudletWeight(CloudletExecution cloudlet) {
        return 1024.0 / Math.pow(1.25, this.getCloudletNiceness(cloudlet));
    }

    protected double getCloudletNiceness(CloudletExecution cloudlet) {
        return -cloudlet.getCloudlet().getPriority();
    }

    private double getCloudletWeightPercentBetweenAllCloudlets(CloudletExecution cloudlet) {
        return this.getCloudletWeight(cloudlet) / this.getWeightSumOfRunningCloudlets();
    }

    private double getWeightSumOfRunningCloudlets() {
        return this.getCloudletExecList().stream().mapToDouble(this::getCloudletWeight).sum();
    }

    public int getMinimumGranularity() {
        return this.minimumGranularity;
    }

    public void setMinimumGranularity(int minimumGranularity) {
        if (minimumGranularity > this.latency) {
            throw new IllegalArgumentException("Minimum granularity cannot be greater than latency.");
        }
        this.minimumGranularity = minimumGranularity;
    }

    @Override
    public double processCloudletSubmit(CloudletExecution rcl, double fileTransferTime) {
        rcl.setVirtualRuntime(this.computeCloudletInitialVirtualRuntime(rcl));
        rcl.setTimeSlice(this.computeCloudletTimeSlice(rcl));
        return super.processCloudletSubmit(rcl, fileTransferTime);
    }

    @Override
    public double updateProcessing(double currentTime, List<Double> mipsShare) {
        super.updateProcessing(currentTime, mipsShare);
        return this.getCloudletExecList().stream().mapToDouble(CloudletExecution::getTimeSlice).min().orElse(Double.MAX_VALUE);
    }

    @Override
    public void updateCloudletProcessing(CloudletExecution rcl, double currentTime) {
        if (rcl.getVirtualRuntime() < 0.0) {
            rcl.setVirtualRuntime(0.0);
        }
        double cloudletTimeSpan = currentTime - rcl.getLastProcessingTime();
        super.updateCloudletProcessing(rcl, currentTime);
        rcl.addVirtualRuntime(cloudletTimeSpan);
    }

    private double computeCloudletInitialVirtualRuntime(CloudletExecution rcl) {
        double inverseOfCloudletId = 2.147483647E9 / ((double)rcl.getCloudletId() + 1.0);
        return -Math.abs((double)rcl.getCloudlet().getPriority() + inverseOfCloudletId);
    }

    @Override
    public boolean canAddCloudletToExecutionList(CloudletExecution cloudlet) {
        return this.isThereEnoughFreePesForCloudlet(cloudlet);
    }

    @Override
    public List<CloudletExecution> getCloudletExecList() {
        return super.getCloudletExecList();
    }

    @Override
    protected void moveNextCloudletsFromWaitingToExecList() {
        List<CloudletExecution> preemptedCloudlets = this.preemptExecCloudletsWithExpiredVRuntimeAndMoveToWaitingList();
        super.moveNextCloudletsFromWaitingToExecList();
        for (CloudletExecution c : preemptedCloudlets) {
            c.setVirtualRuntime(this.computeCloudletInitialVirtualRuntime(c));
        }
    }

    private List<CloudletExecution> preemptExecCloudletsWithExpiredVRuntimeAndMoveToWaitingList() {
        Predicate<CloudletExecution> vrtReachedTimeSlice = c -> c.getVirtualRuntime() >= c.getTimeSlice();
        List<CloudletExecution> expiredVrtCloudlets = this.getCloudletExecList().stream().filter(vrtReachedTimeSlice).collect(Collectors.toList());
        expiredVrtCloudlets.forEach(c -> this.addCloudletToWaitingList(this.removeCloudletFromExecList((CloudletExecution)c)));
        return expiredVrtCloudlets;
    }
}

