/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.cloudlet.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.network.CloudletExecutionTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletReceiveTask;
import org.cloudbus.cloudsim.cloudlets.network.CloudletSendTask;
import org.cloudbus.cloudsim.cloudlets.network.NetworkCloudlet;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.schedulers.cloudlet.network.PacketScheduler;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class PacketSchedulerSimple
implements PacketScheduler {
    private Vm vm;
    private final List<VmPacket> vmPacketsToSend = new ArrayList<VmPacket>();
    private final Map<Vm, List<VmPacket>> vmPacketsReceivedMap = new HashMap<Vm, List<VmPacket>>();

    @Override
    public void processCloudletPackets(Cloudlet cloudlet, double currentTime) {
        if (cloudlet.isFinished() || this.isNotNetworkCloudlet(cloudlet)) {
            return;
        }
        NetworkCloudlet netcl = (NetworkCloudlet)cloudlet;
        if (!netcl.isTasksStarted()) {
            this.scheduleNextTaskIfCurrentIsFinished(netcl);
            return;
        }
        if (this.isTimeToUpdateCloudletProcessing(netcl)) {
            this.updateExecutionTask(netcl);
        } else if (netcl.getCurrentTask() instanceof CloudletSendTask) {
            this.addPacketsToBeSentFromVm(netcl);
        } else if (netcl.getCurrentTask() instanceof CloudletReceiveTask) {
            this.receivePackets(netcl);
        }
    }

    @Override
    public boolean isTimeToUpdateCloudletProcessing(Cloudlet cloudlet) {
        if (Objects.isNull(cloudlet) || cloudlet.isFinished()) {
            return false;
        }
        if (this.isNotNetworkCloudlet(cloudlet)) {
            return true;
        }
        NetworkCloudlet nc = (NetworkCloudlet)cloudlet;
        return nc.isTasksStarted() && nc.getCurrentTask() instanceof CloudletExecutionTask;
    }

    private boolean isNotNetworkCloudlet(Cloudlet cloudlet) {
        return !(cloudlet instanceof NetworkCloudlet);
    }

    private void addPacketsToBeSentFromVm(NetworkCloudlet sourceCloudlet) {
        CloudletSendTask dataTask = (CloudletSendTask)sourceCloudlet.getCurrentTask();
        Log.println(Log.Level.DEBUG, this.getClass(), sourceCloudlet.getSimulation().clock(), "%d pkts added to be sent from cloudlet %d in VM %d", dataTask.getPacketsToSend().size(), sourceCloudlet.getId(), sourceCloudlet.getVm().getId());
        this.vmPacketsToSend.addAll(dataTask.getPacketsToSend(sourceCloudlet.getSimulation().clock()));
        this.scheduleNextTaskIfCurrentIsFinished(sourceCloudlet);
    }

    private void receivePackets(NetworkCloudlet sourceCloudlet) {
        CloudletReceiveTask task = (CloudletReceiveTask)sourceCloudlet.getCurrentTask();
        List<VmPacket> receivedPkts = this.getPacketsSentToGivenTask(task);
        receivedPkts.forEach(task::receivePacket);
        receivedPkts.forEach(pkt -> Log.println(Log.Level.DEBUG, this.getClass(), sourceCloudlet.getSimulation().clock(), "Cloudlet %d in VM %d received pkt with %d bytes from Cloudlet %d in VM %d", pkt.getReceiverCloudlet().getId(), pkt.getDestination().getId(), pkt.getSize(), pkt.getSenderCloudlet().getId(), pkt.getSource().getId()));
        this.getListOfPacketsSentFromVm(task.getSourceVm()).removeAll(receivedPkts);
        this.scheduleNextTaskIfCurrentIsFinished(sourceCloudlet);
    }

    private List<VmPacket> getPacketsSentToGivenTask(CloudletReceiveTask destinationTask) {
        List<VmPacket> pktsFromExpectedSenderVm = this.getListOfPacketsSentFromVm(destinationTask.getSourceVm());
        return pktsFromExpectedSenderVm.stream().filter(pkt -> pkt.getDestination().getId() == destinationTask.getCloudlet().getVm().getId()).collect(Collectors.toList());
    }

    private void updateExecutionTask(NetworkCloudlet cloudlet) {
        CloudletExecutionTask task = (CloudletExecutionTask)cloudlet.getCurrentTask();
        task.process(cloudlet.getFinishedLengthSoFar());
        this.scheduleNextTaskIfCurrentIsFinished(cloudlet);
    }

    private void scheduleNextTaskIfCurrentIsFinished(NetworkCloudlet cloudlet) {
        if (!cloudlet.startNextTaskIfCurrentIsFinished(cloudlet.getSimulation().clock())) {
            return;
        }
        Datacenter dc = this.getVm().getHost().getDatacenter();
        dc.schedule(dc.getId(), dc.getSimulation().getMinTimeBetweenEvents(), 41);
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public void setVm(Vm vm) {
        this.vm = Objects.isNull(vm) ? Vm.NULL : vm;
    }

    @Override
    public void clearVmPacketsToSend() {
        this.vmPacketsToSend.clear();
    }

    @Override
    public List<VmPacket> getVmPacketsToSend() {
        return Collections.unmodifiableList(this.vmPacketsToSend);
    }

    private List<VmPacket> getListOfPacketsSentFromVm(Vm sourceVm) {
        this.vmPacketsReceivedMap.putIfAbsent(sourceVm, new ArrayList());
        return this.vmPacketsReceivedMap.get(sourceVm);
    }

    @Override
    public boolean addPacketToListOfPacketsSentFromVm(VmPacket pkt) {
        return this.getListOfPacketsSentFromVm(pkt.getSource()).add(pkt);
    }
}

