/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.vms.Vm;

public abstract class VmSchedulerAbstract
implements VmScheduler {
    public static final double DEFAULT_VM_MIGRATION_CPU_OVERHEAD = 0.1;
    private Map<Vm, List<Double>> mipsMapRequested;
    private Host host;
    private Map<Vm, List<Pe>> peMap;
    private Map<Vm, List<Double>> mipsMapAllocated;
    private final double vmMigrationCpuOverhead;

    public VmSchedulerAbstract() {
        this(0.1);
    }

    public VmSchedulerAbstract(double vmMigrationCpuOverhead) {
        if (vmMigrationCpuOverhead < 0.0 || vmMigrationCpuOverhead >= 1.0) {
            throw new IllegalArgumentException("vmMigrationCpuOverhead must be a percentage value between [0 and 1[");
        }
        this.setHost(Host.NULL);
        this.vmMigrationCpuOverhead = vmMigrationCpuOverhead;
        this.mipsMapRequested = new HashMap<Vm, List<Double>>();
    }

    @Override
    public final boolean isSuitableForVm(Vm vm) {
        return this.isSuitableForVm(vm.getCurrentRequestedMips());
    }

    @Override
    public final boolean allocatePesForVm(Vm vm) {
        List<Double> mipsShareRequested = LongStream.range(0L, vm.getNumberOfPes()).mapToObj(i -> vm.getMips()).collect(Collectors.toList());
        return this.allocatePesForVm(vm, mipsShareRequested);
    }

    @Override
    public final boolean allocatePesForVm(Vm vm, List<Double> mipsShareRequested) {
        if (!vm.isInMigration() && this.host.getVmsMigratingOut().contains(vm)) {
            this.host.removeVmMigratingOut(vm);
        }
        this.mipsMapRequested.put(vm, mipsShareRequested);
        return this.allocatePesForVmInternal(vm, mipsShareRequested);
    }

    protected abstract boolean allocatePesForVmInternal(Vm var1, List<Double> var2);

    @Override
    public void deallocatePesFromVm(Vm vm) {
        this.deallocatePesFromVm(vm, (int)vm.getNumberOfPes());
    }

    @Override
    public void deallocatePesFromVm(Vm vm, int pesToRemove) {
        if (pesToRemove <= 0 || vm.getNumberOfPes() == 0L) {
            return;
        }
        this.deallocatePesFromVmInternal(vm, pesToRemove);
    }

    protected <T> int removePesFromMap(Vm vm, Map<Vm, List<T>> map, int pesToRemove) {
        List values = map.getOrDefault(vm, new ArrayList());
        if (values.isEmpty()) {
            return 0;
        }
        pesToRemove = Math.min((int)vm.getNumberOfPes(), pesToRemove);
        pesToRemove = Math.min(pesToRemove, values.size());
        IntStream.range(0, pesToRemove).forEach(i -> values.remove(0));
        if (values.isEmpty()) {
            map.remove(vm);
        }
        return pesToRemove;
    }

    protected abstract void deallocatePesFromVmInternal(Vm var1, int var2);

    @Override
    public void deallocatePesForAllVms() {
        this.mipsMapAllocated.clear();
        this.getWorkingPeList().forEach(pe -> pe.getPeProvisioner().deallocateResourceForAllVms());
    }

    @Override
    public List<Pe> getPesAllocatedForVm(Vm vm) {
        return this.peMap.getOrDefault(vm, new ArrayList());
    }

    @Override
    public List<Double> getAllocatedMips(Vm vm) {
        List<Double> list = this.mipsMapAllocated.getOrDefault(vm, new ArrayList());
        return this.host.getVmsMigratingOut().contains(vm) ? this.getMipsShareRequestedReduced(vm, list) : list;
    }

    protected List<Double> getMipsShareRequestedReduced(Vm vm, List<Double> mipsShareRequested) {
        double peMips = this.getPeCapacity();
        return mipsShareRequested.stream().map(mips -> Math.min(mips, peMips) * this.percentOfMipsToRequest(vm)).collect(Collectors.toList());
    }

    @Override
    public double getTotalAllocatedMipsForVm(Vm vm) {
        return this.getAllocatedMips(vm).stream().mapToDouble(v -> v).sum();
    }

    @Override
    public double getMaxAvailableMips() {
        return this.getWorkingPeList().stream().map(Pe::getPeProvisioner).mapToDouble(ResourceProvisioner::getAvailableResource).max().orElse(0.0);
    }

    @Override
    public long getPeCapacity() {
        return this.getWorkingPeList().stream().map(Pe::getCapacity).findFirst().orElse(0L);
    }

    public final List<Pe> getWorkingPeList() {
        return this.host.getWorkingPeList();
    }

    protected Map<Vm, List<Double>> getMipsMapRequested() {
        return this.mipsMapRequested;
    }

    @Override
    public List<Double> getRequestedMips(Vm vm) {
        return new ArrayList<Double>((Collection)this.mipsMapRequested.getOrDefault(vm, Collections.EMPTY_LIST));
    }

    protected Map<Vm, List<Double>> getMipsMapAllocated() {
        return this.mipsMapAllocated;
    }

    protected final void setMipsMapAllocated(Map<Vm, List<Double>> mipsMapAllocated) {
        this.mipsMapAllocated = mipsMapAllocated;
    }

    @Override
    public double getAvailableMips() {
        double totalAllocatedMips = this.mipsMapAllocated.keySet().stream().mapToDouble(this::actualVmTotalRequestedMips).sum();
        return this.host.getTotalMipsCapacity() - totalAllocatedMips;
    }

    private double actualVmTotalRequestedMips(Vm vm) {
        double totalVmRequestedMips = ((List)this.getMipsMapAllocated().getOrDefault(vm, new ArrayList())).stream().reduce(0.0, Double::sum);
        return totalVmRequestedMips / this.percentOfMipsToRequest(vm);
    }

    protected double percentOfMipsToRequest(Vm vm) {
        if (this.host.getVmsMigratingIn().contains(vm)) {
            return this.vmMigrationCpuOverhead;
        }
        if (this.host.getVmsMigratingOut().contains(vm)) {
            return this.getMaxCpuUsagePercentDuringOutMigration();
        }
        return 1.0;
    }

    @Override
    public double getMaxCpuUsagePercentDuringOutMigration() {
        return 1.0 - this.vmMigrationCpuOverhead;
    }

    @Override
    public double getVmMigrationCpuOverhead() {
        return this.vmMigrationCpuOverhead;
    }

    protected Map<Vm, List<Pe>> getPeMap() {
        return this.peMap;
    }

    protected final void setPeMap(Map<Vm, List<Pe>> peMap) {
        this.peMap = peMap;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public VmScheduler setHost(Host host) {
        Objects.requireNonNull(host);
        if (this.isOtherHostAssigned(host)) {
            throw new IllegalArgumentException("VmScheduler already has a Host assigned to it. Each Host must have its own VmScheduler instance.");
        }
        this.host = host;
        this.setPeMap(new HashMap<Vm, List<Pe>>());
        this.setMipsMapAllocated(new HashMap<Vm, List<Double>>());
        return this;
    }

    private boolean isOtherHostAssigned(Host host) {
        return !Objects.isNull(this.host) && this.host != Host.NULL && !host.equals(this.host);
    }

    @Override
    public boolean isAllowedToAllocateMips(List<Double> vmRequestedMipsShare) {
        double pmMips = this.getPeCapacity();
        double totalRequestedMips = 0.0;
        for (double vmMips : vmRequestedMipsShare) {
            if (vmMips > pmMips) {
                return false;
            }
            totalRequestedMips += vmMips;
        }
        return !(this.getAvailableMips() < totalRequestedMips) && this.getWorkingPeList().size() >= vmRequestedMipsShare.size();
    }
}

