/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmScheduler;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSchedulerSpaceShared
extends VmSchedulerAbstract {
    private Map<Vm, List<Pe>> peAllocationMap;
    private List<Pe> freePesList;

    public VmSchedulerSpaceShared() {
        this(0.1);
    }

    public VmSchedulerSpaceShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
        this.setPeAllocationMap(new HashMap<Vm, List<Pe>>());
        this.setFreePesList(new ArrayList<Pe>());
    }

    @Override
    public VmScheduler setHost(Host host) {
        super.setHost(host);
        this.setPeAllocationMap(new HashMap<Vm, List<Pe>>());
        this.setFreePesList(new ArrayList<Pe>(this.getHost().getWorkingPeList()));
        return this;
    }

    @Override
    public boolean isSuitableForVm(List<Double> vmMipsList) {
        return !this.getTotalCapacityToBeAllocatedToVm(vmMipsList).isEmpty();
    }

    protected List<Pe> getTotalCapacityToBeAllocatedToVm(List<Double> vmRequestedMipsShare) {
        if (this.freePesList.size() < vmRequestedMipsShare.size()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Pe> selectedPes = new ArrayList<Pe>();
        Iterator<Pe> peIterator = this.freePesList.iterator();
        Pe pe = peIterator.next();
        for (double mips : vmRequestedMipsShare) {
            if (!(mips <= (double)pe.getCapacity())) continue;
            selectedPes.add(pe);
            if (!peIterator.hasNext()) break;
            pe = peIterator.next();
        }
        if (vmRequestedMipsShare.size() > selectedPes.size()) {
            return Collections.EMPTY_LIST;
        }
        return selectedPes;
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, List<Double> mipsShareRequested) {
        List<Pe> selectedPes = this.getTotalCapacityToBeAllocatedToVm(mipsShareRequested);
        if (selectedPes.isEmpty()) {
            return false;
        }
        double totalMips = mipsShareRequested.stream().mapToDouble(m -> m).sum();
        this.freePesList.removeAll(selectedPes);
        this.peAllocationMap.put(vm, selectedPes);
        this.getMipsMapAllocated().put(vm, mipsShareRequested);
        return true;
    }

    @Override
    protected void deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        this.freePesList.addAll(this.getAllocatedWorkingPesForVm(vm));
        this.removePesFromMap(vm, this.peAllocationMap, pesToRemove);
        this.removePesFromMap(vm, this.getMipsMapAllocated(), pesToRemove);
    }

    private List<Pe> getAllocatedWorkingPesForVm(Vm vm) {
        return ((List)this.peAllocationMap.getOrDefault(vm, new ArrayList())).stream().filter(Pe::isWorking).collect(Collectors.toList());
    }

    protected final void setPeAllocationMap(Map<Vm, List<Pe>> peAllocationMap) {
        this.peAllocationMap = peAllocationMap;
    }

    protected Map<Vm, List<Pe>> getPeAllocationMap() {
        return this.peAllocationMap;
    }

    protected final void setFreePesList(List<Pe> freePesList) {
        this.freePesList = freePesList;
    }

    protected final List<Pe> getFreePesList() {
        return this.freePesList;
    }
}

