/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSchedulerTimeShared
extends VmSchedulerAbstract {
    private long pesInUse;

    public VmSchedulerTimeShared() {
        this(0.1);
    }

    public VmSchedulerTimeShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, List<Double> mipsShareRequested) {
        if (!this.allocateMipsShareForVmInternal(vm, mipsShareRequested)) {
            return false;
        }
        this.updatePesAllocationForAllVms();
        return true;
    }

    protected boolean allocateMipsShareForVmInternal(Vm vm, List<Double> mipsShareRequested) {
        if (!this.isAllowedToAllocateMips(mipsShareRequested)) {
            return false;
        }
        this.setPesInUse(this.getPesInUse() + (long)mipsShareRequested.size());
        this.allocateMipsShareForVm(vm, mipsShareRequested);
        return true;
    }

    protected void allocateMipsShareForVm(Vm vm, List<Double> mipsShareRequestedReduced) {
        List<Double> mipsShare = this.getMipsShareToAllocate(vm, mipsShareRequestedReduced);
        this.getMipsMapAllocated().put(vm, mipsShare);
    }

    private void updatePesAllocationForAllVms() {
        this.clearAllocationOfPesForAllVms();
        this.getMipsMapAllocated().entrySet().forEach(this::allocatePesListForVm);
    }

    private void clearAllocationOfPesForAllVms() {
        this.getPeMap().clear();
        this.getHost().getPeList().forEach(pe -> pe.getPeProvisioner().deallocateResourceForAllVms());
    }

    private void allocatePesListForVm(Map.Entry<Vm, List<Double>> entry) {
        Vm vm = entry.getKey();
        Iterator<Pe> hostPesIterator = this.getWorkingPeList().iterator();
        for (double requestedMipsForVmPe : entry.getValue()) {
            double allocatedMipsForVmPe = this.allocateMipsFromHostPesToGivenVirtualPe(vm, requestedMipsForVmPe, hostPesIterator);
            if (!(requestedMipsForVmPe > 0.1) || !(allocatedMipsForVmPe <= 0.1)) continue;
            this.logMipsUnavailable(vm, requestedMipsForVmPe, allocatedMipsForVmPe);
        }
    }

    private void logMipsUnavailable(Vm vm, double requestedMipsForVmPe, double allocatedMipsForVmPe) {
        String msg = allocatedMipsForVmPe > 0.0 ? String.format("Only %.0f MIPS were allocated.", allocatedMipsForVmPe) : "No MIPS were allocated.";
        Log.printFormattedLine("%.2f: %s: %s is requiring a total of %.0f MIPS but the PEs of %s\n\t currently don't have such an available MIPS amount. %s", this.getHost().getSimulation().clock(), this.getClass().getSimpleName(), vm, requestedMipsForVmPe, this.getHost(), msg);
    }

    private double allocateMipsFromHostPesToGivenVirtualPe(Vm vm, double requestedMipsForVmPe, Iterator<Pe> hostPesIterator) {
        if (requestedMipsForVmPe <= 0.0) {
            return 0.0;
        }
        double allocatedMipsForVmPe = 0.0;
        while (allocatedMipsForVmPe <= 0.0 && hostPesIterator.hasNext()) {
            Pe selectedHostPe = hostPesIterator.next();
            if (this.allocateAllVmPeRequestedMipsFromHostPe(vm, selectedHostPe, requestedMipsForVmPe)) {
                allocatedMipsForVmPe = requestedMipsForVmPe;
                continue;
            }
            allocatedMipsForVmPe += this.allocatedAvailableMipsFromHostPeToVirtualPe(vm, selectedHostPe);
        }
        return allocatedMipsForVmPe;
    }

    private double allocatedAvailableMipsFromHostPeToVirtualPe(Vm vm, Pe hostPe) {
        double availableMips = this.getAvailableMipsFromHostPe(hostPe);
        if (availableMips <= 0.0) {
            return 0.0;
        }
        this.allocateMipsFromHostPeForVm(vm, hostPe, availableMips);
        return availableMips;
    }

    private boolean allocateAllVmPeRequestedMipsFromHostPe(Vm vm, Pe hostPe, double requestedMipsForVmPe) {
        if ((double)this.getAvailableMipsFromHostPe(hostPe) >= requestedMipsForVmPe) {
            this.allocateMipsFromHostPeForVm(vm, hostPe, requestedMipsForVmPe);
            return true;
        }
        return false;
    }

    private long getAvailableMipsFromHostPe(Pe hostPe) {
        return hostPe.getPeProvisioner().getAvailableResource();
    }

    private void allocateMipsFromHostPeForVm(Vm vm, Pe pe, double mipsToAllocate) {
        pe.getPeProvisioner().allocateResourceForVm(vm, (long)mipsToAllocate);
        ((List)this.getPeMap().getOrDefault(vm, new ArrayList())).add(pe);
    }

    @Override
    public boolean isSuitableForVm(List<Double> vmMipsList) {
        return this.isAllowedToAllocateMips(vmMipsList);
    }

    protected List<Double> getMipsShareToAllocate(Vm vm, List<Double> mipsShareRequested) {
        return this.getMipsShareToAllocate(vm, mipsShareRequested, this.percentOfMipsToRequest(vm));
    }

    protected List<Double> getMipsShareToAllocate(Vm vm, List<Double> mipsShareRequested, double scalingFactor) {
        return mipsShareRequested.stream().map(mips -> mips * scalingFactor).collect(Collectors.toList());
    }

    @Override
    protected void deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        int removedPes = this.removePesFromMap(vm, this.getMipsMapRequested(), pesToRemove);
        this.setPesInUse(this.pesInUse - (long)removedPes);
        this.removePesFromMap(vm, this.getMipsMapAllocated(), pesToRemove);
        for (Map.Entry<Vm, List<Double>> entry : this.getMipsMapRequested().entrySet()) {
            this.allocateMipsShareForVmInternal(entry.getKey(), entry.getValue());
        }
        this.updatePesAllocationForAllVms();
    }

    @Override
    public void deallocatePesForAllVms() {
        super.deallocatePesForAllVms();
        this.getMipsMapRequested().clear();
        this.setPesInUse(0L);
    }

    protected void setPesInUse(long pesInUse) {
        this.pesInUse = Math.max(pesInUse, 0L);
    }

    protected long getPesInUse() {
        return this.pesInUse;
    }
}

