/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerTimeShared;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSchedulerTimeSharedOverSubscription
extends VmSchedulerTimeShared {
    public VmSchedulerTimeSharedOverSubscription() {
        this(0.1);
    }

    public VmSchedulerTimeSharedOverSubscription(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    public boolean isAllowedToAllocateMips(List<Double> vmRequestedMipsShare) {
        return this.getWorkingPeList().size() >= vmRequestedMipsShare.size();
    }

    @Override
    protected void allocateMipsShareForVm(Vm vm, List<Double> mipsShareRequestedReduced) {
        double totalRequestedMips = mipsShareRequestedReduced.stream().reduce(0.0, Double::sum);
        if (this.getAvailableMips() >= totalRequestedMips) {
            super.allocateMipsShareForVm(vm, mipsShareRequestedReduced);
            return;
        }
        this.redistributeMipsDueToOverSubscription();
    }

    protected void redistributeMipsDueToOverSubscription() {
        Map<Vm, List<Double>> mipsMapRequestedReduced = this.getNewTotalRequestedMipsByAllVms();
        double scalingFactor = this.getVmsMipsScalingFactor(mipsMapRequestedReduced);
        this.getMipsMapAllocated().clear();
        for (Map.Entry<Vm, List<Double>> entry : mipsMapRequestedReduced.entrySet()) {
            Vm vm = entry.getKey();
            List<Double> updatedMipsAllocation = this.getMipsShareToAllocate(vm, entry.getValue());
            updatedMipsAllocation = this.getMipsShareToAllocate(vm, updatedMipsAllocation, scalingFactor);
            this.getMipsMapAllocated().put(vm, updatedMipsAllocation);
        }
    }

    private double getVmsMipsScalingFactor(Map<Vm, List<Double>> mipsMapRequestedReduced) {
        double totalMipsCapacity = this.getHost().getTotalMipsCapacity();
        double totalMipsToAllocateForAllVms = this.getTotalMipsToAllocateForAllVms(mipsMapRequestedReduced);
        return Math.min(1.0, totalMipsCapacity / totalMipsToAllocateForAllVms);
    }

    private Map<Vm, List<Double>> getNewTotalRequestedMipsByAllVms() {
        HashMap<Vm, List<Double>> mipsMapRequestedReduced = new HashMap<Vm, List<Double>>(this.getMipsMapRequested().entrySet().size());
        for (Map.Entry<Vm, List<Double>> entry : this.getMipsMapRequested().entrySet()) {
            Vm vm = entry.getKey();
            List<Double> mipsShareRequestedReduced = this.getMipsShareRequestedReduced(entry.getKey(), entry.getValue());
            mipsMapRequestedReduced.put(vm, mipsShareRequestedReduced);
        }
        return mipsMapRequestedReduced;
    }

    private double getTotalMipsToAllocateForAllVms(Map<Vm, List<Double>> mipsMapRequestedReduced) {
        return mipsMapRequestedReduced.entrySet().stream().mapToDouble(this::getMipsToBeAllocatedForVmPes).sum();
    }

    private double getMipsToBeAllocatedForVmPes(Map.Entry<Vm, List<Double>> entry) {
        double requiredMipsByThisVm = entry.getValue().stream().reduce(0.0, Double::sum);
        if (this.getHost().getVmsMigratingIn().contains(entry.getKey())) {
            return requiredMipsByThisVm * this.getVmMigrationCpuOverhead();
        }
        return requiredMipsByThisVm;
    }
}

