/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies.power;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.power.PowerVm;

public class PowerVmSelectionPolicyMaximumCorrelation
extends PowerVmSelectionPolicy {
    private PowerVmSelectionPolicy fallbackPolicy;

    public PowerVmSelectionPolicyMaximumCorrelation(PowerVmSelectionPolicy fallbackPolicy) {
        this.setFallbackPolicy(fallbackPolicy);
    }

    @Override
    public Vm getVmToMigrate(PowerHost host) {
        List<PowerVm> migratableVms = this.getMigratableVms(host);
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        try {
            List<Double> metrics = this.getCorrelationCoefficients(this.getUtilizationMatrix(migratableVms));
            double maxMetric = Double.MIN_VALUE;
            int maxIndex = 0;
            for (int i = 0; i < metrics.size(); ++i) {
                double metric = metrics.get(i);
                if (!(metric > maxMetric)) continue;
                maxMetric = metric;
                maxIndex = i;
            }
            return migratableVms.get(maxIndex);
        }
        catch (IllegalArgumentException e) {
            return this.getFallbackPolicy().getVmToMigrate(host);
        }
    }

    protected double[][] getUtilizationMatrix(List<PowerVm> vmList) {
        int numberVms = vmList.size();
        int minHistorySize = this.getMinUtilizationHistorySize(vmList);
        double[][] utilization = new double[numberVms][minHistorySize];
        for (int i = 0; i < numberVms; ++i) {
            List<Double> vmUtilization = vmList.get(i).getUtilizationHistory();
            for (int j = 0; j < minHistorySize; ++j) {
                utilization[i][j] = vmUtilization.get(j);
            }
        }
        return utilization;
    }

    protected int getMinUtilizationHistorySize(List<PowerVm> vmList) {
        return vmList.stream().map(PowerVm::getUtilizationHistory).mapToInt(List::size).min().orElse(0);
    }

    protected List<Double> getCorrelationCoefficients(double[][] data) {
        int n = data.length;
        int m = data[0].length;
        LinkedList<Double> correlationCoefficients = new LinkedList<Double>();
        for (int i = 0; i < n; ++i) {
            double[][] x = new double[n - 1][m];
            int k = 0;
            for (int j = 0; j < n; ++j) {
                if (j == i) continue;
                x[k++] = data[j];
            }
            double[][] xT = new Array2DRowRealMatrix(x).transpose().getData();
            correlationCoefficients.add(MathUtil.createLinearRegression(xT, data[i]).calculateRSquared());
        }
        return correlationCoefficients;
    }

    public PowerVmSelectionPolicy getFallbackPolicy() {
        return this.fallbackPolicy;
    }

    public final void setFallbackPolicy(PowerVmSelectionPolicy fallbackPolicy) {
        this.fallbackPolicy = fallbackPolicy;
    }
}

