/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies.power;

import java.util.List;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.power.PowerVm;

public class PowerVmSelectionPolicyMinimumMigrationTime
extends PowerVmSelectionPolicy {
    @Override
    public Vm getVmToMigrate(PowerHost host) {
        List<PowerVm> migratableVms = this.getMigratableVms(host);
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        Vm vmToMigrate = Vm.NULL;
        double minMetric = Double.MAX_VALUE;
        for (Vm vm : migratableVms) {
            double metric;
            if (vm.isInMigration() || !((metric = (double)vm.getRam().getCapacity()) < minMetric)) continue;
            minMetric = metric;
            vmToMigrate = vm;
        }
        return vmToMigrate;
    }
}

