/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies.power;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.hosts.power.PowerHost;
import org.cloudbus.cloudsim.selectionpolicies.power.PowerVmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.power.PowerVm;

public class PowerVmSelectionPolicyMinimumUtilization
extends PowerVmSelectionPolicy {
    @Override
    public Vm getVmToMigrate(PowerHost host) {
        List<PowerVm> migratableVms = this.getMigratableVms(host);
        if (migratableVms.isEmpty()) {
            return Vm.NULL;
        }
        Predicate<Vm> inMigration = Vm::isInMigration;
        Comparator<Vm> cpuUsageComparator = Comparator.comparingDouble(vm -> vm.getCpuPercentUsage(vm.getSimulation().clock()));
        Optional<Vm> optional = migratableVms.stream().filter(inMigration.negate()).min(cpuUsageComparator);
        return optional.isPresent() ? optional.get() : Vm.NULL;
    }
}

