/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.util.Objects;

public final class Log {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static OutputStream output;
    private static boolean disabled;
    private static StringBuilder buffer;
    private static boolean debug;

    private Log() {
    }

    public static void print(String message) {
        if (Log.isEnabled()) {
            try {
                Log.getOutput().write(message.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void print(Object message) {
        Log.print(String.valueOf(message));
    }

    public static void printLine(String message) {
        Log.print(message + LINE_SEPARATOR);
    }

    public static void printLine() {
        Log.print(LINE_SEPARATOR);
    }

    public static void printLine(Object message) {
        Log.printLine(String.valueOf(message));
    }

    public static void printConcat(Object ... messages) {
        if (Log.isEnabled()) {
            buffer = new StringBuilder(messages.length);
            for (Object message : messages) {
                buffer.append(String.valueOf(message));
            }
            Log.print(buffer);
        }
    }

    public static void printConcatLine(Object ... messages) {
        if (Log.isEnabled()) {
            buffer = new StringBuilder(messages.length);
            for (Object message : messages) {
                buffer.append(String.valueOf(message));
            }
            Log.printLine(buffer);
        }
    }

    public static void printFormatted(String format, Object ... args) {
        Log.print(String.format(format, args));
    }

    public static void printFormattedLine(String format, Object ... args) {
        Log.printLine(String.format(format, args));
    }

    public static void println(Level level, Class klass, double time, String format, Object ... args) {
        if (level == Level.DEBUG && Log.isDebug() || level != Level.DEBUG) {
            String msg = String.format(format, args);
            Log.printFormattedLine("Time %.1f %s/%s\n   %s", time, level.name(), klass.getSimpleName(), msg);
        }
    }

    public static void setOutput(OutputStream newOutput) {
        output = newOutput;
    }

    public static OutputStream getOutput() {
        if (Objects.isNull(output)) {
            Log.setOutput(System.out);
        }
        return output;
    }

    public static void setDisabled(boolean disable) {
        disabled = disable;
    }

    public static boolean isDisabled() {
        return disabled;
    }

    public static boolean isEnabled() {
        return !disabled;
    }

    public static void disable() {
        Log.setDisabled(true);
    }

    public static void enable() {
        Log.setDisabled(false);
    }

    public static boolean isDebug() {
        return debug;
    }

    static {
        buffer = new StringBuilder();
        debug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("jdwp") > 0;
    }

    public static enum Level {
        INFO,
        ERROR,
        DEBUG;

    }
}

