/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public final class MathUtil {
    public static final double HUNDRED_PERCENT = 0.1;

    private MathUtil() {
    }

    public static double sum(List<? extends Number> list) {
        return list.stream().mapToDouble(Number::doubleValue).sum();
    }

    public static double[] listToArray(List<? extends Number> list) {
        return list.stream().mapToDouble(Number::doubleValue).toArray();
    }

    public static double median(List<Double> list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static double median(double ... list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static DescriptiveStatistics getStatistics(List<Double> list) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        list.forEach(arg_0 -> ((DescriptiveStatistics)stats).addValue(arg_0));
        return stats;
    }

    public static DescriptiveStatistics getStatistics(double ... list) {
        return new DescriptiveStatistics(list);
    }

    public static double mean(List<Double> list) {
        return list.stream().mapToDouble(n -> n).average().orElse(0.0);
    }

    public static double variance(List<Double> list) {
        long n = 0L;
        double mean = MathUtil.mean(list);
        double s = 0.0;
        for (double x : list) {
            double delta = x - mean;
            s += delta * (x - (mean += delta / (double)(++n)));
        }
        return s / (double)(n - 1L);
    }

    public static double stDev(List<Double> list) {
        return Math.sqrt(MathUtil.variance(list));
    }

    public static double mad(double ... data) {
        if (data.length == 0) {
            return 0.0;
        }
        double median = MathUtil.median(data);
        double[] deviationSum = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            deviationSum[i] = Math.abs(median - data[i]);
        }
        return MathUtil.median(deviationSum);
    }

    public static double iqr(double ... data) {
        Arrays.sort(data);
        int q1 = (int)Math.round(0.25 * (double)(data.length + 1)) - 1;
        int q3 = (int)Math.round(0.75 * (double)(data.length + 1)) - 1;
        return data[q3] - data[q1];
    }

    public static int countNonZeroBeginning(double ... data) {
        int i = data.length - 1;
        while (i >= 0 && data[i--] == 0.0) {
        }
        return i + 2;
    }

    public static int countShortestRow(double[][] data) {
        int minLength = 0;
        for (double[] row : data) {
            minLength = Math.min(row.length, minLength);
        }
        return minLength;
    }

    public static double[] trimZeroTail(double ... data) {
        return Arrays.copyOfRange(data, 0, MathUtil.countNonZeroBeginning(data));
    }

    public static double[] getLoessParameterEstimates(double ... y) {
        double[] x = new double[y.length];
        for (int i = 0; i < y.length; ++i) {
            x[i] = i + 1;
        }
        return MathUtil.createWeigthedLinearRegression(x, y, MathUtil.getTricubeWeights(y.length)).regress().getParameterEstimates();
    }

    public static SimpleRegression createLinearRegression(double[] x, double[] y) {
        SimpleRegression regression = new SimpleRegression();
        for (int i = 0; i < x.length; ++i) {
            regression.addData(x[i], y[i]);
        }
        return regression;
    }

    public static OLSMultipleLinearRegression createLinearRegression(double[][] x, double[] y) {
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.newSampleData(y, x);
        return regression;
    }

    public static SimpleRegression createWeigthedLinearRegression(double[] x, double[] y, double[] weigths) {
        double[] xW = new double[x.length];
        double[] yW = new double[y.length];
        long numZeroWeigths = Arrays.stream(weigths).filter(weigth -> weigth <= 0.0).count();
        for (int i = 0; i < x.length; ++i) {
            if ((double)numZeroWeigths >= 0.4 * (double)weigths.length) {
                xW[i] = Math.sqrt(weigths[i]) * x[i];
                yW[i] = Math.sqrt(weigths[i]) * y[i];
                continue;
            }
            xW[i] = x[i];
            yW[i] = y[i];
        }
        return MathUtil.createLinearRegression(xW, yW);
    }

    public static double[] getRobustLoessParameterEstimates(double ... y) {
        int n = y.length;
        double[] x = new double[n];
        for (int i = 0; i < n; ++i) {
            x[i] = i + 1;
        }
        SimpleRegression tricubeRegression = MathUtil.createWeigthedLinearRegression(x, y, MathUtil.getTricubeWeights(n));
        double[] residuals = new double[n];
        for (int i = 0; i < n; ++i) {
            residuals[i] = y[i] - tricubeRegression.predict(x[i]);
        }
        SimpleRegression tricubeBySqrRegression = MathUtil.createWeigthedLinearRegression(x, y, MathUtil.getTricubeBisquareWeights(residuals));
        double[] estimates = tricubeBySqrRegression.regress().getParameterEstimates();
        if (Double.isNaN(estimates[0]) || Double.isNaN(estimates[1])) {
            return tricubeRegression.regress().getParameterEstimates();
        }
        return estimates;
    }

    public static double[] getTricubeWeights(int n) {
        double[] weights = new double[n];
        double top = n - 1;
        for (int i = 2; i < n; ++i) {
            double k = Math.pow(1.0 - Math.pow((top - (double)i) / top, 3.0), 3.0);
            weights[i] = k > 0.0 ? 1.0 / k : Double.MAX_VALUE;
        }
        weights[0] = weights[1] = weights[2];
        return weights;
    }

    public static double[] getTricubeBisquareWeights(double ... residuals) {
        int n = residuals.length;
        double[] weights = MathUtil.getTricubeWeights(n);
        double[] weights2 = new double[n];
        double s6 = MathUtil.median(MathUtil.abs(residuals)) * 6.0;
        for (int i = 2; i < n; ++i) {
            double k = Math.pow(1.0 - Math.pow(residuals[i] / s6, 2.0), 2.0);
            weights2[i] = k > 0.0 ? 1.0 / k * weights[i] : Double.MAX_VALUE;
        }
        weights2[0] = weights2[1] = weights2[2];
        return weights2;
    }

    public static double[] abs(double ... data) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.abs(data[i]);
        }
        return result;
    }

    public static int doubleToInt(double d) {
        return (int)(d < 0.0 ? Math.floor(d) : Math.ceil(d));
    }
}

