/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.util.WorkloadReader;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelFull;

public class WorkloadFileReader
implements WorkloadReader {
    private final File file;
    private int mips;
    private final List<Cloudlet> cloudlets;
    private int jobNum = 0;
    private int submitTime = 1;
    private int runTime = 3;
    private int numProc = 4;
    private int reqNumProc = 7;
    private int reqRunTime = 8;
    private int userId = 11;
    private int groupId = 12;
    private int maxField = 18;
    private String comment = ";";
    private final int IRRELEVANT = -1;
    private String[] fieldArray;
    private int maxLinesToRead;
    private Predicate<Cloudlet> predicate;

    public WorkloadFileReader(String fileName, int mips) throws FileNotFoundException {
        if (Objects.isNull(fileName) || fileName.isEmpty()) {
            throw new IllegalArgumentException("Invalid trace file name.");
        }
        this.setMips(mips);
        this.predicate = c -> true;
        this.file = new File(fileName);
        if (!this.file.exists()) {
            throw new FileNotFoundException("Workload trace " + fileName + " does not exist");
        }
        this.cloudlets = new ArrayList<Cloudlet>();
        this.maxLinesToRead = -1;
    }

    public static WorkloadFileReader getInstanceFromResourcesDir(String fileName, int mips) throws FileNotFoundException {
        return new WorkloadFileReader(ResourceLoader.getResourcePath(WorkloadFileReader.class, fileName), mips);
    }

    @Override
    public List<Cloudlet> generateWorkload() throws IOException {
        if (this.cloudlets.isEmpty()) {
            this.fieldArray = new String[this.maxField];
            if (this.file.getName().endsWith(".gz")) {
                this.readGZIPFile(this.file);
            } else if (this.file.getName().endsWith(".zip")) {
                this.readZipFile(this.file);
            } else {
                this.readTextFile(this.file);
            }
        }
        return this.cloudlets;
    }

    @Override
    public WorkloadReader setPredicate(Predicate<Cloudlet> predicate) {
        this.predicate = predicate;
        return this;
    }

    public boolean setComment(String cmt) {
        boolean success = false;
        if (!Objects.isNull(cmt) && !cmt.isEmpty()) {
            this.comment = cmt;
            success = true;
        }
        return success;
    }

    public void setField(int maxField, int jobNum, int submitTime, int runTime, int numProc) {
        if (jobNum > 0) {
            this.jobNum = jobNum - 1;
        } else {
            if (jobNum == 0) {
                throw new IllegalArgumentException("Invalid job number field.");
            }
            this.jobNum = -1;
        }
        if (maxField <= 0) {
            throw new IllegalArgumentException("Invalid max. number of field.");
        }
        this.maxField = maxField;
        if (submitTime <= 0) {
            throw new IllegalArgumentException("Invalid submit time field.");
        }
        this.submitTime = submitTime - 1;
        if (runTime <= 0) {
            throw new IllegalArgumentException("Invalid run time field.");
        }
        this.reqRunTime = runTime - 1;
        if (numProc <= 0) {
            throw new IllegalArgumentException("Invalid number of processors field.");
        }
        this.reqNumProc = numProc - 1;
    }

    private Cloudlet createCloudlet(int id, long submitTime, int runTime, int numProc, int userID, int groupID) {
        int len = runTime * this.mips;
        UtilizationModelFull utilizationModel = new UtilizationModelFull();
        Cloudlet cloudlet = new CloudletSimple(id, len, numProc).setFileSize(1500L).setOutputSize(1500L).setUtilizationModel(utilizationModel);
        return cloudlet;
    }

    private Cloudlet createCloudletFromTraceLine(String[] array, int lineNumber) {
        int numProc;
        Integer obj;
        int id;
        if (this.jobNum == -1) {
            id = this.cloudlets.size() + 1;
        } else {
            obj = Integer.valueOf(array[this.jobNum].trim());
            id = obj;
        }
        Long l = Long.valueOf(array[this.submitTime].trim());
        long submitTime = l.intValue();
        obj = Integer.valueOf(array[this.runTime].trim());
        int runTime = obj;
        int userID = Integer.valueOf(array[this.userId].trim());
        int groupID = Integer.valueOf(array[this.groupId].trim());
        if (runTime <= 0) {
            runTime = 1;
        }
        if ((numProc = (obj = Integer.valueOf(array[this.reqNumProc].trim())).intValue()) == -1 || numProc == 0) {
            obj = Integer.valueOf(array[this.numProc].trim());
            numProc = obj;
        }
        if (numProc <= 0) {
            numProc = 1;
        }
        return this.createCloudlet(id, submitTime, runTime, numProc, userID, groupID);
    }

    private Cloudlet parseTraceLineAndCreateCloudlet(String line, int lineNum) {
        if (line.startsWith(this.comment)) {
            return Cloudlet.NULL;
        }
        String[] sp = line.split("\\s+");
        int index = 0;
        for (String elem : sp) {
            if (elem.trim().isEmpty()) continue;
            this.fieldArray[index] = elem;
            ++index;
        }
        if (index < this.maxField) {
            return Cloudlet.NULL;
        }
        Cloudlet c = this.createCloudletFromTraceLine(this.fieldArray, lineNum);
        return this.predicate.test(c) ? c : Cloudlet.NULL;
    }

    private void readFile(InputStream inputStream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String readLine;
            int line = 1;
            while ((readLine = this.readNextLine(reader, line)) != null) {
                Cloudlet c = this.parseTraceLineAndCreateCloudlet(readLine, line);
                if (c == Cloudlet.NULL) continue;
                this.cloudlets.add(c);
                ++line;
            }
        }
    }

    protected void readTextFile(File fl) throws IOException {
        this.readFile(new FileInputStream(fl));
    }

    protected void readGZIPFile(File fl) throws IOException {
        this.readFile(new GZIPInputStream(new FileInputStream(fl)));
    }

    protected boolean readZipFile(File fl) throws IOException {
        try (ZipFile zipFile = new ZipFile(fl);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry zipEntry = zipEntries.nextElement();
                this.readFile(zipFile.getInputStream(zipEntry));
            }
            boolean bl = true;
            return bl;
        }
    }

    private String readNextLine(BufferedReader reader, int lineNumber) throws IOException {
        if (reader.ready() && (this.maxLinesToRead == -1 || lineNumber <= this.maxLinesToRead)) {
            return reader.readLine();
        }
        return null;
    }

    public int getMaxLinesToRead() {
        return this.maxLinesToRead;
    }

    public void setMaxLinesToRead(int maxLinesToRead) {
        this.maxLinesToRead = maxLinesToRead;
    }

    public int getMips() {
        return this.mips;
    }

    public final WorkloadFileReader setMips(int mips) {
        if (mips <= 0) {
            throw new IllegalArgumentException("MIPS must be greater than 0.");
        }
        this.mips = mips;
        return this;
    }
}

