/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.util.Objects;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;

public abstract class UtilizationModelAbstract
implements UtilizationModel {
    public static final double ALMOST_ZERO = 1.0E-10;
    private Simulation simulation = Simulation.NULL;
    private UtilizationModel.Unit unit;

    public UtilizationModelAbstract() {
        this(UtilizationModel.Unit.PERCENTAGE);
    }

    public UtilizationModelAbstract(UtilizationModel.Unit unit) {
        this.setUnit(unit);
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    @Override
    public UtilizationModel.Unit getUnit() {
        return this.unit;
    }

    protected final UtilizationModel setUnit(UtilizationModel.Unit unit) {
        Objects.requireNonNull(unit);
        this.unit = unit;
        return this;
    }

    @Override
    public UtilizationModel setSimulation(Simulation simulation) {
        Objects.requireNonNull(simulation);
        this.simulation = simulation;
        return this;
    }

    @Override
    public double getUtilization() {
        return this.getUtilization(this.simulation.clock());
    }

    protected void validateUtilizationField(String fieldName, double fieldValue) {
        this.validateUtilizationField(fieldName, fieldValue, 0.0);
    }

    protected void validateUtilizationField(String fieldName, double fieldValue, double minValue) {
        double d = minValue = minValue <= 1.0E-10 ? 0.0 : minValue;
        if (fieldValue < minValue) {
            throw new IllegalArgumentException(fieldName + " cannot be lower than " + minValue);
        }
    }
}

