/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelDynamic
extends UtilizationModelAbstract {
    private boolean readOnly = false;
    private double currentUtilization = 0.0;
    private double maxResourceUtilization;
    private Function<UtilizationModelDynamic, Double> utilizationUpdateFunction;
    private double previousUtilizationTime;
    private double currentUtilizationTime;

    public UtilizationModelDynamic() {
        this(UtilizationModel.Unit.PERCENTAGE, 0.0);
    }

    public UtilizationModelDynamic(UtilizationModel.Unit unit) {
        this(unit, 0.0);
    }

    public UtilizationModelDynamic(double initialUtilizationPercent) {
        this(UtilizationModel.Unit.PERCENTAGE, initialUtilizationPercent);
    }

    public UtilizationModelDynamic(UtilizationModel.Unit unit, double initialUtilization) {
        super(unit);
        this.maxResourceUtilization = unit == UtilizationModel.Unit.PERCENTAGE ? 1.0 : 0.0;
        this.previousUtilizationTime = 0.0;
        this.currentUtilizationTime = 0.0;
        this.setCurrentUtilization(initialUtilization);
        this.utilizationUpdateFunction = um -> um.currentUtilization;
    }

    protected UtilizationModelDynamic(UtilizationModelDynamic source) {
        this(source.getUnit(), source.currentUtilization);
        this.currentUtilizationTime = source.currentUtilizationTime;
        this.previousUtilizationTime = source.previousUtilizationTime;
        this.maxResourceUtilization = source.maxResourceUtilization;
        this.readOnly = true;
    }

    @Override
    public double getUtilization(double time) {
        this.currentUtilizationTime = time;
        if (this.previousUtilizationTime != time) {
            this.currentUtilization = this.utilizationUpdateFunction.apply(new UtilizationModelDynamic(this));
            this.previousUtilizationTime = time;
            if (this.currentUtilization <= 0.0) {
                this.currentUtilization = 0.0;
            }
            if (this.currentUtilization > this.maxResourceUtilization && this.maxResourceUtilization > 0.0) {
                this.currentUtilization = this.maxResourceUtilization;
            }
        }
        return this.currentUtilization;
    }

    @Override
    public double getUtilization() {
        return this.readOnly ? this.currentUtilization : super.getUtilization();
    }

    public double getTimeSpan() {
        return this.currentUtilizationTime - this.previousUtilizationTime;
    }

    private void setCurrentUtilization(double currentUtilization) {
        this.validateUtilizationField("currentUtilization", currentUtilization);
        this.currentUtilization = currentUtilization;
    }

    public double getMaxResourceUtilization() {
        return this.maxResourceUtilization;
    }

    public final UtilizationModelDynamic setMaxResourceUtilization(double maxResourceUsagePercentage) {
        this.validateUtilizationField("maxResourceUtilization", maxResourceUsagePercentage, 1.0E-10);
        this.maxResourceUtilization = maxResourceUsagePercentage;
        return this;
    }

    public final UtilizationModelDynamic setUtilizationUpdateFunction(Function<UtilizationModelDynamic, Double> utilizationUpdateFunction) {
        Objects.requireNonNull(utilizationUpdateFunction);
        this.utilizationUpdateFunction = utilizationUpdateFunction;
        return this;
    }
}

