/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.utilizationmodels;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelAbstract;

public class UtilizationModelPlanetLab
extends UtilizationModelAbstract {
    private double schedulingInterval;
    private final double[] data;

    public UtilizationModelPlanetLab(String inputPath, double schedulingInterval) throws NumberFormatException, IOException {
        this(inputPath, schedulingInterval, 289);
    }

    public UtilizationModelPlanetLab(String inputPath, double schedulingInterval, int dataSamples) throws NumberFormatException, IOException {
        this.setSchedulingInterval(schedulingInterval);
        this.data = this.readWorkloadFile(inputPath, dataSamples);
    }

    private double[] readWorkloadFile(String inputPath, int dataSamples) throws IOException {
        dataSamples = Math.max(2, dataSamples);
        double[] data = this.createEmptyArray(dataSamples);
        try (BufferedReader input = new BufferedReader(new FileReader(inputPath));){
            String line;
            int n = data.length;
            int i = 0;
            while ((line = input.readLine()) != null && i < n) {
                data[i++] = (double)Integer.valueOf(line).intValue() / 100.0;
            }
            data[n - 1] = data[n - 2];
        }
        return data;
    }

    private double[] createEmptyArray(int size) {
        double[] data = new double[size];
        for (int i = 0; i < size; ++i) {
            data[i] = 0.0;
        }
        return data;
    }

    @Override
    public double getUtilization(double time) {
        if (time % this.getSchedulingInterval() == 0.0) {
            return this.data[(int)time / (int)this.getSchedulingInterval()];
        }
        int time1 = (int)Math.floor(time / this.getSchedulingInterval());
        int time2 = (int)Math.ceil(time / this.getSchedulingInterval());
        double utilization1 = this.data[time1];
        double utilization2 = this.data[time2];
        double delta = (utilization2 - utilization1) / ((double)(time2 - time1) * this.getSchedulingInterval());
        return utilization1 + delta * (time - (double)time1 * this.getSchedulingInterval());
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public final void setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
    }
}

