/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.UniquelyIdentificable;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.resources.Storage;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmStateHistoryEntry;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;

public class VmSimple
implements Vm {
    private HorizontalVmScaling horizontalScaling;
    private boolean failed;
    private int id;
    private DatacenterBroker broker;
    private Processor processor;
    private String vmm;
    private CloudletScheduler cloudletScheduler;
    private Host host;
    private boolean inMigration;
    private boolean created;
    private List<ResourceManageable> resources = new ArrayList<ResourceManageable>(4);
    private final List<VmStateHistoryEntry> stateHistory;
    private Storage storage;
    private Ram ram;
    private Bandwidth bw;
    private double submissionDelay;
    private Set<EventListener<VmHostEventInfo>> onHostAllocationListeners;
    private Set<EventListener<VmHostEventInfo>> onHostDeallocationListeners;
    private Set<EventListener<VmHostEventInfo>> onUpdateProcessingListeners;
    private Set<EventListener<VmDatacenterEventInfo>> onCreationFailureListeners;
    private VerticalVmScaling ramVerticalScaling;
    private VerticalVmScaling bwVerticalScaling;
    private VerticalVmScaling peVerticalScaling;
    private String description;
    private double startTime;
    private double stopTime;
    private double lastBuzyTime;

    public VmSimple(int id, long mipsCapacity, long numberOfPes) {
        this.setInMigration(false);
        this.setHost(Host.NULL);
        this.setCloudletScheduler(CloudletScheduler.NULL);
        this.processor = new Processor(this, mipsCapacity, numberOfPes);
        this.description = "";
        this.startTime = -1.0;
        this.stopTime = -1.0;
        this.lastBuzyTime = 0.0;
        this.setId(id);
        this.setBroker(DatacenterBroker.NULL);
        this.setMips(mipsCapacity);
        this.setNumberOfPes(numberOfPes);
        this.setRam(new Ram(1024L));
        this.setBw(new Bandwidth(1000L));
        this.setStorage(new Storage(1024L));
        this.setSubmissionDelay(0.0);
        this.setVmm("Xen");
        this.stateHistory = new LinkedList<VmStateHistoryEntry>();
        this.onHostAllocationListeners = new HashSet<EventListener<VmHostEventInfo>>();
        this.onHostDeallocationListeners = new HashSet<EventListener<VmHostEventInfo>>();
        this.onCreationFailureListeners = new HashSet<EventListener<VmDatacenterEventInfo>>();
        this.onUpdateProcessingListeners = new HashSet<EventListener<VmHostEventInfo>>();
        this.setHorizontalScaling(HorizontalVmScaling.NULL);
        this.setRamVerticalScaling(VerticalVmScaling.NULL);
        this.setBwVerticalScaling(VerticalVmScaling.NULL);
        this.setPeVerticalScaling(VerticalVmScaling.NULL);
    }

    public VmSimple(long mipsCapacity, long numberOfPes) {
        this(-1, mipsCapacity, numberOfPes);
    }

    public VmSimple(int id, double mipsCapacity, long numberOfPes) {
        this(id, (long)mipsCapacity, numberOfPes);
    }

    @Deprecated
    public VmSimple(int id, DatacenterBroker broker, long mipsCapacity, int numberOfPes, long ramCapacity, long bwCapacity, long size, String vmm, CloudletScheduler cloudletScheduler) {
        this(id, mipsCapacity, (long)numberOfPes);
        this.setBroker(broker);
        this.setRam(ramCapacity);
        this.setBw(bwCapacity);
        this.setSize(size);
        this.setVmm(vmm);
        this.setCloudletScheduler(cloudletScheduler);
    }

    @Override
    public double updateProcessing(double currentTime, List<Double> mipsShare) {
        if (Objects.isNull(mipsShare)) {
            return Double.MAX_VALUE;
        }
        if (!this.cloudletScheduler.getCloudletExecList().isEmpty()) {
            this.lastBuzyTime = this.getSimulation().clock();
        }
        double nextSimulationTime = this.cloudletScheduler.updateProcessing(currentTime, mipsShare);
        this.notifyOnUpdateProcessingListeners();
        return nextSimulationTime;
    }

    @Override
    public double getCpuPercentUsage() {
        return this.getCpuPercentUsage(this.getSimulation().clock());
    }

    @Override
    public double getCpuPercentUsage(double time) {
        return this.cloudletScheduler.getRequestedCpuPercentUtilization(time);
    }

    @Override
    public double getTotalCpuMipsUsage(double time) {
        return this.getCpuPercentUsage(time) * this.getTotalMipsCapacity();
    }

    @Override
    public double getCurrentRequestedMaxMips() {
        return this.getCurrentRequestedMips().stream().mapToDouble(m -> m).max().orElse(0.0);
    }

    @Override
    public double getCurrentRequestedTotalMips() {
        return this.getCurrentRequestedMips().stream().mapToDouble(m -> m).sum();
    }

    @Override
    public List<Double> getCurrentRequestedMips() {
        if (this.isCreated()) {
            return this.host.getVmScheduler().getRequestedMips(this);
        }
        return LongStream.range(0L, this.getNumberOfPes()).mapToObj(i -> this.getMips()).collect(Collectors.toList());
    }

    @Override
    public long getCurrentRequestedBw() {
        if (!this.isCreated()) {
            return this.bw.getCapacity();
        }
        return (long)(this.cloudletScheduler.getCurrentRequestedBwPercentUtilization() * (double)this.bw.getCapacity());
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.getMips() * (double)this.getNumberOfPes();
    }

    @Override
    public long getCurrentRequestedRam() {
        if (!this.isCreated()) {
            return this.ram.getCapacity();
        }
        return (long)(this.cloudletScheduler.getCurrentRequestedRamPercentUtilization() * (double)this.ram.getCapacity());
    }

    @Override
    public String getUid() {
        return UniquelyIdentificable.getUid(this.broker.getId(), this.id);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public final void setId(int id) {
        this.id = id;
    }

    @Override
    public final Vm setBroker(DatacenterBroker broker) {
        this.broker = Objects.isNull(broker) ? DatacenterBroker.NULL : broker;
        return this;
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public Vm setStartTime(double startTime) {
        this.startTime = Math.max(startTime, -1.0);
        return this;
    }

    @Override
    public double getStopTime() {
        return this.stopTime;
    }

    @Override
    public Vm setStopTime(double stopTime) {
        this.stopTime = Math.max(stopTime, -1.0);
        return this;
    }

    @Override
    public double getLastBuzyTime() {
        return this.lastBuzyTime;
    }

    @Override
    public double getIdleInterval() {
        return this.getSimulation().clock() - this.lastBuzyTime;
    }

    @Override
    public double getTotalExecutionTime() {
        if (this.startTime < 0.0) {
            return 0.0;
        }
        return this.stopTime < 0.0 ? this.getSimulation().clock() - this.startTime : this.stopTime - this.startTime;
    }

    @Override
    public DatacenterBroker getBroker() {
        return this.broker;
    }

    @Override
    public double getMips() {
        return this.processor.getMips();
    }

    protected final void setMips(double mips) {
        this.processor.setMips(mips);
    }

    @Override
    public long getNumberOfPes() {
        return this.processor.getCapacity();
    }

    private void setNumberOfPes(long numberOfPes) {
        this.processor.setCapacity(numberOfPes);
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Resource getRam() {
        return this.ram;
    }

    private void setRam(Ram ram) {
        Objects.requireNonNull(ram);
        this.ram = ram;
    }

    @Override
    public final Vm setRam(long ramCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("RAM capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setRam(new Ram(ramCapacity));
        return this;
    }

    @Override
    public Resource getBw() {
        return this.bw;
    }

    private void setBw(Bandwidth bw) {
        Objects.requireNonNull(bw);
        this.bw = bw;
    }

    @Override
    public final Vm setBw(long bwCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Bandwidth capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setBw(new Bandwidth(bwCapacity));
        return this;
    }

    @Override
    public Resource getStorage() {
        return this.storage;
    }

    private void setStorage(Storage storage) {
        Objects.requireNonNull(storage);
        this.storage = storage;
    }

    @Override
    public final Vm setSize(long size) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Storage size can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setStorage(new Storage(size));
        return this;
    }

    @Override
    public String getVmm() {
        return this.vmm;
    }

    protected final void setVmm(String vmm) {
        this.vmm = vmm;
    }

    @Override
    public final void setHost(Host host) {
        if (host == Host.NULL) {
            this.setCreated(false);
        }
        this.host = host;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public CloudletScheduler getCloudletScheduler() {
        return this.cloudletScheduler;
    }

    @Override
    public final Vm setCloudletScheduler(CloudletScheduler cloudletScheduler) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("CloudletScheduler can just be changed when the Vm was not created inside a Host yet.");
        }
        this.cloudletScheduler = Objects.isNull(cloudletScheduler) ? CloudletScheduler.NULL : cloudletScheduler;
        this.cloudletScheduler.setVm(this);
        return this;
    }

    @Override
    public boolean isInMigration() {
        return this.inMigration;
    }

    @Override
    public final void setInMigration(boolean inMigration) {
        this.inMigration = inMigration;
    }

    @Override
    public long getCurrentAllocatedSize() {
        return this.storage.getAllocatedResource();
    }

    @Override
    public long getCurrentAllocatedRam() {
        return this.ram.getAllocatedResource();
    }

    @Override
    public long getCurrentAllocatedBw() {
        return this.bw.getAllocatedResource();
    }

    @Override
    public final boolean isCreated() {
        return this.created;
    }

    @Override
    public final void setCreated(boolean created) {
        this.created = created;
    }

    @Override
    public List<VmStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public void addStateHistoryEntry(VmStateHistoryEntry entry) {
        VmStateHistoryEntry previousState;
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == entry.getTime()) {
            this.stateHistory.set(this.stateHistory.size() - 1, entry);
            return;
        }
        this.stateHistory.add(entry);
    }

    @Override
    public void allocateResource(Class<? extends ResourceManageable> resourceClass, long newTotalResourceAmount) {
        this.getResource(resourceClass).allocateResource(newTotalResourceAmount);
    }

    @Override
    public void deallocateResource(Class<? extends ResourceManageable> resourceClass) {
        this.getResource(resourceClass).deallocateAllResources();
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.getSimulation().isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ram, this.bw, this.storage, this.processor);
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public Vm addOnHostAllocationListener(EventListener<VmHostEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onHostAllocationListeners.add(listener);
        return this;
    }

    @Override
    public Vm addOnHostDeallocationListener(EventListener<VmHostEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onHostDeallocationListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnHostAllocationListener(EventListener<VmHostEventInfo> listener) {
        return this.onHostAllocationListeners.remove(listener);
    }

    @Override
    public boolean removeOnHostDeallocationListener(EventListener<VmHostEventInfo> listener) {
        return this.onHostDeallocationListeners.remove(listener);
    }

    public String toString() {
        String desc = this.description.trim().isEmpty() ? "" : String.format(" (%s)", this.description);
        return String.format("Vm %d%s", this.getId(), desc);
    }

    @Override
    public Vm addOnCreationFailureListener(EventListener<VmDatacenterEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onCreationFailureListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnCreationFailureListener(EventListener<VmDatacenterEventInfo> listener) {
        return this.onCreationFailureListeners.remove(listener);
    }

    @Override
    public Vm addOnUpdateProcessingListener(EventListener<VmHostEventInfo> listener) {
        Objects.requireNonNull(listener);
        this.onUpdateProcessingListeners.add(listener);
        return this;
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<VmHostEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(listener);
    }

    @Override
    public int compareTo(Vm o) {
        return Double.compare(this.getTotalMipsCapacity(), o.getTotalMipsCapacity());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VmSimple vmSimple = (VmSimple)o;
        if (this.id != vmSimple.id) {
            return false;
        }
        return this.broker.equals(vmSimple.broker);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.broker.hashCode();
        return result;
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public Simulation getSimulation() {
        return this.broker.getSimulation();
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        this.submissionDelay = submissionDelay;
    }

    @Override
    public void notifyOnHostAllocationListeners() {
        VmHostEventInfo info = VmHostEventInfo.of(this);
        this.onHostAllocationListeners.forEach(l -> l.update(info));
    }

    @Override
    public void notifyOnHostDeallocationListeners(Host deallocatedHost) {
        if (Objects.isNull(deallocatedHost)) {
            return;
        }
        VmHostEventInfo info = VmHostEventInfo.of(this, deallocatedHost);
        this.onHostDeallocationListeners.forEach(l -> l.update(info));
    }

    public void notifyOnUpdateProcessingListeners() {
        VmHostEventInfo info = VmHostEventInfo.of(this);
        this.onUpdateProcessingListeners.forEach(l -> l.update(info));
    }

    @Override
    public void notifyOnCreationFailureListeners(Datacenter failedDatacenter) {
        if (Objects.isNull(failedDatacenter)) {
            return;
        }
        VmDatacenterEventInfo info = VmDatacenterEventInfo.of(this, failedDatacenter);
        this.onCreationFailureListeners.forEach(l -> l.update(info));
    }

    @Override
    public HorizontalVmScaling getHorizontalScaling() {
        return this.horizontalScaling;
    }

    @Override
    public final Vm setHorizontalScaling(HorizontalVmScaling horizontalScaling) throws IllegalArgumentException {
        this.horizontalScaling = this.validateAndConfigureVmScaling(horizontalScaling);
        return this;
    }

    @Override
    public final Vm setRamVerticalScaling(VerticalVmScaling ramVerticalScaling) throws IllegalArgumentException {
        this.ramVerticalScaling = this.validateAndConfigureVmScaling(ramVerticalScaling);
        return this;
    }

    @Override
    public final Vm setBwVerticalScaling(VerticalVmScaling bwVerticalScaling) throws IllegalArgumentException {
        this.bwVerticalScaling = this.validateAndConfigureVmScaling(bwVerticalScaling);
        return this;
    }

    @Override
    public final Vm setPeVerticalScaling(VerticalVmScaling peVerticalScaling) throws IllegalArgumentException {
        this.peVerticalScaling = this.validateAndConfigureVmScaling(peVerticalScaling);
        return this;
    }

    @Override
    public VerticalVmScaling getRamVerticalScaling() {
        return this.ramVerticalScaling;
    }

    @Override
    public VerticalVmScaling getBwVerticalScaling() {
        return this.bwVerticalScaling;
    }

    @Override
    public VerticalVmScaling getPeVerticalScaling() {
        return this.peVerticalScaling;
    }

    private <T extends VmScaling> T validateAndConfigureVmScaling(T vmScaling) {
        Objects.requireNonNull(vmScaling);
        if (vmScaling.getVm() != null && vmScaling.getVm() != Vm.NULL && vmScaling.getVm() != this) {
            String name = vmScaling.getClass().getSimpleName();
            throw new IllegalArgumentException("The " + name + " given is already linked to a Vm. Each Vm must have its own " + name + " objects or none at all. A new scaling has to be provided for this Vm.");
        }
        vmScaling.setVm(this);
        this.addOnUpdateProcessingListener(evt -> vmScaling.requestScalingIfPredicateMatch(evt.getTime()));
        return vmScaling;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Vm setDescription(String description) {
        this.description = Objects.isNull(description) ? "" : description;
        return this;
    }
}

