/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms.power;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.util.MathUtil;
import org.cloudbus.cloudsim.vms.VmSimple;

public class PowerVm
extends VmSimple {
    public static final int MAX_HISTORY_ENTRIES = 30;
    private final List<Double> utilizationHistory = new LinkedList<Double>();
    private double previousTime;

    public PowerVm(int id, long mipsCapacity, int numberOfPes) {
        super(id, mipsCapacity, (long)numberOfPes);
    }

    public PowerVm(long mipsCapacity, int numberOfPes) {
        this(-1, mipsCapacity, numberOfPes);
    }

    @Deprecated
    public PowerVm(int id, DatacenterBroker broker, long mipsCapacity, int numberOfPes, int ramCapacity, long bwCapacity, long size, int priority, String vmm, CloudletScheduler cloudletScheduler, double schedulingInterval) {
        this(id, mipsCapacity, numberOfPes);
        this.setBroker(broker);
        this.setRam(ramCapacity);
        this.setBw(bwCapacity);
        this.setSize(size);
        this.setVmm(vmm);
        this.setCloudletScheduler(cloudletScheduler);
    }

    @Override
    public double updateProcessing(double currentTime, List<Double> mipsShare) {
        double time = super.updateProcessing(currentTime, mipsShare);
        if (currentTime > this.getPreviousTime() && (currentTime - 0.1) % this.getHost().getDatacenter().getSchedulingInterval() == 0.0) {
            double utilization = this.getCpuPercentUsage(this.getCloudletScheduler().getPreviousTime());
            if (currentTime != 0.0 || utilization != 0.0) {
                this.addUtilizationHistoryValue(utilization);
            }
            this.setPreviousTime(currentTime);
        }
        return time;
    }

    public double getUtilizationMad() {
        if (!this.getUtilizationHistory().isEmpty()) {
            int n = Math.min(30, this.getUtilizationHistory().size());
            double median = MathUtil.median(this.getUtilizationHistory());
            double[] deviationSum = new double[n];
            for (int i = 0; i < n; ++i) {
                deviationSum[i] = Math.abs(median - this.getUtilizationHistory().get(i));
            }
            return MathUtil.median(deviationSum);
        }
        return 0.0;
    }

    public double getUtilizationMean() {
        if (!this.getUtilizationHistory().isEmpty()) {
            int maxNumOfEntriesToAverage = Math.min(30, this.getUtilizationHistory().size());
            double usagePercentMean = this.getUtilizationHistory().stream().limit(maxNumOfEntriesToAverage).mapToDouble(usagePercent -> usagePercent).average().orElse(0.0);
            return usagePercentMean * this.getMips();
        }
        return 0.0;
    }

    public double getUtilizationVariance() {
        if (!this.getUtilizationHistory().isEmpty()) {
            double mean = this.getUtilizationMean();
            int maxNumOfEntriesToAverage = Math.min(30, this.getUtilizationHistory().size());
            return this.getUtilizationHistory().stream().limit(maxNumOfEntriesToAverage).mapToDouble(usagePercent -> usagePercent * this.getMips()).map(usageValue -> usageValue - mean).map(usageValue -> usageValue * usageValue).average().orElse(0.0);
        }
        return 0.0;
    }

    public void addUtilizationHistoryValue(double utilization) {
        this.utilizationHistory.add(0, utilization);
        if (this.getUtilizationHistory().size() > 30) {
            this.utilizationHistory.remove(30);
        }
    }

    public List<Double> getUtilizationHistory() {
        return Collections.unmodifiableList(this.utilizationHistory);
    }

    public double getPreviousTime() {
        return this.previousTime;
    }

    public void setPreviousTime(double previousTime) {
        this.previousTime = previousTime;
    }
}

