/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;

public class HorizontalVmScalingSimple
extends VmScalingAbstract
implements HorizontalVmScaling {
    private Supplier<Vm> vmSupplier;
    private long cloudletCreationRequests;
    private Predicate<Vm> underloadPredicate = FALSE_PREDICATE;
    private Predicate<Vm> overloadPredicate = FALSE_PREDICATE;

    public HorizontalVmScalingSimple() {
        this.vmSupplier = () -> Vm.NULL;
    }

    @Override
    public Supplier<Vm> getVmSupplier() {
        return this.vmSupplier;
    }

    @Override
    public final HorizontalVmScaling setVmSupplier(Supplier<Vm> supplier) {
        this.vmSupplier = Objects.isNull(supplier) ? () -> Vm.NULL : supplier;
        return this;
    }

    @Override
    public Predicate<Vm> getOverloadPredicate() {
        return this.overloadPredicate;
    }

    @Override
    public VmScaling setOverloadPredicate(Predicate<Vm> predicate) {
        this.validateFunctions(this.underloadPredicate, predicate);
        this.overloadPredicate = predicate;
        return this;
    }

    private void validateFunctions(Predicate<Vm> underloadPredicate, Predicate<Vm> overloadPredicate) {
        Objects.requireNonNull(underloadPredicate);
        Objects.requireNonNull(overloadPredicate);
        if (overloadPredicate.equals(underloadPredicate)) {
            throw new IllegalArgumentException("Under and overload predicates cannot be equal.");
        }
    }

    @Override
    public Predicate<Vm> getUnderloadPredicate() {
        return this.underloadPredicate;
    }

    @Override
    public VmScaling setUnderloadPredicate(Predicate<Vm> predicate) {
        this.validateFunctions(predicate, this.overloadPredicate);
        this.underloadPredicate = predicate;
        return this;
    }

    @Override
    protected boolean requestScaling(double time) {
        return this.requestUpScaling(time);
    }

    private boolean requestUpScaling(double time) {
        if (!this.isNewCloudletsArrived()) {
            return false;
        }
        double vmCpuUsagerPercent = this.getVm().getCpuPercentUsage() * 100.0;
        Vm newVm = this.getVmSupplier().get();
        Log.printFormattedLine("\t%.2f: %s%d: Requesting creation of Vm %d to receive new Cloudlets in order to balance load of Vm %d. Vm %d CPU usage is %.2f%%", time, this.getClass().getSimpleName(), this.getVm().getId(), newVm.getId(), this.getVm().getId(), this.getVm().getId(), vmCpuUsagerPercent);
        this.getVm().getBroker().submitVm(newVm);
        this.cloudletCreationRequests = this.getVm().getBroker().getCloudletCreatedList().size();
        return true;
    }

    private boolean isNewCloudletsArrived() {
        return (long)this.getVm().getBroker().getCloudletCreatedList().size() > this.cloudletCreationRequests;
    }

    @Override
    public final boolean requestScalingIfPredicateMatch(double time) {
        if (!this.isTimeToCheckPredicate(time)) {
            return false;
        }
        boolean requestedScaling = (this.getUnderloadPredicate().test(this.getVm()) || this.getOverloadPredicate().test(this.getVm())) && this.requestScaling(time);
        this.setLastProcessingTime(time);
        return requestedScaling;
    }
}

