/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;
import org.cloudsimplus.autoscaling.resources.ResourceScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScalingGradual;

public class VerticalVmScalingSimple
extends VmScalingAbstract
implements VerticalVmScaling {
    private ResourceScaling resourceScaling;
    private double scalingFactor;
    private Class<? extends ResourceManageable> resourceClassToScale;
    private Function<Vm, Double> upperUtilizationThresholdFunction;
    private Function<Vm, Double> lowerUtilizationThresholdFunction;

    public VerticalVmScalingSimple(Class<? extends ResourceManageable> resourceClassToScale, double scalingFactor) {
        this.setResourceScaling(new ResourceScalingGradual());
        this.lowerUtilizationThresholdFunction = VerticalVmScaling.NULL.getLowerThresholdFunction();
        this.upperUtilizationThresholdFunction = VerticalVmScaling.NULL.getUpperThresholdFunction();
        this.setResourceClass(resourceClassToScale);
        this.setScalingFactor(scalingFactor);
    }

    @Override
    public Function<Vm, Double> getUpperThresholdFunction() {
        return this.upperUtilizationThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setUpperThresholdFunction(Function<Vm, Double> upperThresholdFunction) {
        this.validateFunctions(this.lowerUtilizationThresholdFunction, upperThresholdFunction);
        this.upperUtilizationThresholdFunction = upperThresholdFunction;
        return this;
    }

    @Override
    public Function<Vm, Double> getLowerThresholdFunction() {
        return this.lowerUtilizationThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setLowerThresholdFunction(Function<Vm, Double> lowerThresholdFunction) {
        this.validateFunctions(lowerThresholdFunction, this.upperUtilizationThresholdFunction);
        this.lowerUtilizationThresholdFunction = lowerThresholdFunction;
        return this;
    }

    @Override
    public final VerticalVmScaling setResourceScaling(ResourceScaling resourceScaling) {
        Objects.requireNonNull(resourceScaling);
        this.resourceScaling = resourceScaling;
        return this;
    }

    @Override
    public long getAllocatedResource() {
        return this.getResource().getAllocatedResource();
    }

    private void validateFunctions(Function<Vm, Double> lowerThresholdFunction, Function<Vm, Double> upperThresholdFunction) {
        Objects.requireNonNull(lowerThresholdFunction);
        Objects.requireNonNull(upperThresholdFunction);
        if (upperThresholdFunction.equals(lowerThresholdFunction)) {
            throw new IllegalArgumentException("Lower and Upper utilization threshold functions cannot be equal.");
        }
    }

    @Override
    public Class<? extends ResourceManageable> getResourceClass() {
        return this.resourceClassToScale;
    }

    @Override
    public final VerticalVmScaling setResourceClass(Class<? extends ResourceManageable> resourceClass) {
        Objects.requireNonNull(resourceClass);
        this.resourceClassToScale = resourceClass;
        if (Pe.class.equals(this.resourceClassToScale)) {
            this.resourceClassToScale = Processor.class;
        }
        return this;
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public final boolean requestScalingIfPredicateMatch(double time) {
        if (!this.isTimeToCheckPredicate(time)) {
            return false;
        }
        boolean requestedScaling = (this.isVmUnderloaded() || this.isVmOverloaded()) && this.requestScaling(time);
        this.setLastProcessingTime(time);
        return requestedScaling;
    }

    @Override
    public boolean isVmUnderloaded() {
        return this.getResource().getPercentUtilization() < this.lowerUtilizationThresholdFunction.apply(this.getVm());
    }

    @Override
    public boolean isVmOverloaded() {
        return this.getResource().getPercentUtilization() > this.upperUtilizationThresholdFunction.apply(this.getVm());
    }

    @Override
    public Resource getResource() {
        return this.getVm().getResource(this.resourceClassToScale);
    }

    @Override
    public double getResourceAmountToScale() {
        return Math.ceil(this.resourceScaling.getResourceAmountToScale(this));
    }

    @Override
    public Function<Vm, Double> getResourceUsageThresholdFunction() {
        if (this.isVmUnderloaded()) {
            return this.lowerUtilizationThresholdFunction;
        }
        if (this.isVmOverloaded()) {
            return this.upperUtilizationThresholdFunction;
        }
        return vm -> 0.0;
    }

    @Override
    public final VerticalVmScaling setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
        return this;
    }

    @Override
    protected boolean requestScaling(double time) {
        Vm vm = this.getVm();
        vm.getSimulation().sendNow(vm.getId(), vm.getBroker().getId(), 42, this);
        return true;
    }
}

