/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VmScaling;

public abstract class VmScalingAbstract
implements VmScaling {
    private double lastProcessingTime;
    private Vm vm;

    protected VmScalingAbstract() {
        this.setVm(Vm.NULL);
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public final VmScaling setVm(Vm vm) {
        Objects.requireNonNull(vm);
        this.vm = vm;
        return this;
    }

    protected boolean isTimeToCheckPredicate(double time) {
        return time > this.lastProcessingTime && (double)((long)time) % this.getVm().getHost().getDatacenter().getSchedulingInterval() == 0.0;
    }

    protected abstract boolean requestScaling(double var1);

    protected void setLastProcessingTime(double lastProcessingTime) {
        this.lastProcessingTime = lastProcessingTime;
    }
}

