/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling.resources;

import java.util.function.Function;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScaling;
import org.cloudsimplus.autoscaling.resources.ResourceScalingGradual;

public class ResourceScalingInstantaneous
implements ResourceScaling {
    private static final ResourceScaling gradual = new ResourceScalingGradual();

    @Override
    public double getResourceAmountToScale(VerticalVmScaling vmScaling) {
        Function<Vm, Double> thresholdFunction = vmScaling.getResourceUsageThresholdFunction();
        double newResourceSize = Math.ceil((double)vmScaling.getResource().getAllocatedResource() * 0.1 / thresholdFunction.apply(vmScaling.getVm()));
        double extraSafetyCapacity = gradual.getResourceAmountToScale(vmScaling);
        return newResourceSize + extraSafetyCapacity;
    }
}

