/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.builders.BrokerBuilderDecorator;
import org.cloudsimplus.builders.BrokerBuilderInterface;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.builders.SimulationScenarioBuilder;

public class BrokerBuilder
extends Builder
implements BrokerBuilderInterface {
    private static final String BROKER_NAME_FORMAT = "Broker%d";
    private final List<DatacenterBroker> brokers;
    private final SimulationScenarioBuilder scenario;

    public BrokerBuilder(SimulationScenarioBuilder scenario) {
        this.scenario = scenario;
        this.brokers = new ArrayList<DatacenterBroker>();
    }

    @Override
    public BrokerBuilderDecorator createBroker() {
        DatacenterBrokerSimple broker = new DatacenterBrokerSimple(this.scenario.getSimulation());
        this.brokers.add(broker);
        return new BrokerBuilderDecorator(this, broker);
    }

    @Override
    public List<DatacenterBroker> getBrokers() {
        return this.brokers;
    }

    @Override
    public DatacenterBroker get(int index) {
        return this.brokers.get(index);
    }

    @Override
    public DatacenterBroker findBroker(int id) {
        return this.brokers.stream().filter(b -> b.getId() == id).findFirst().orElseThrow(() -> new NoSuchElementException(String.format("There isn't a broker with id %d", id)));
    }
}

