/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudsimplus.builders.BrokerBuilder;
import org.cloudsimplus.builders.BrokerBuilderInterface;
import org.cloudsimplus.builders.CloudletBuilder;
import org.cloudsimplus.builders.VmBuilder;

public class BrokerBuilderDecorator
implements BrokerBuilderInterface {
    private final BrokerBuilder builder;
    private final VmBuilder vmBuilder;
    private final CloudletBuilder cloudletBuilder;
    private final DatacenterBroker broker;

    public BrokerBuilderDecorator(BrokerBuilder builder, DatacenterBrokerSimple broker) {
        if (Objects.isNull(builder)) {
            throw new IllegalArgumentException("The builder parameter cannot be null.");
        }
        if (Objects.isNull(broker)) {
            throw new IllegalArgumentException("The broker parameter cannot be null.");
        }
        this.builder = builder;
        this.broker = broker;
        this.vmBuilder = new VmBuilder(broker);
        this.cloudletBuilder = new CloudletBuilder(this, broker);
    }

    @Override
    public BrokerBuilderDecorator createBroker() {
        return this.builder.createBroker();
    }

    @Override
    public DatacenterBroker findBroker(int id) {
        return this.builder.findBroker(id);
    }

    @Override
    public List<DatacenterBroker> getBrokers() {
        return this.builder.getBrokers();
    }

    @Override
    public DatacenterBroker get(int index) {
        return this.builder.get(index);
    }

    public VmBuilder getVmBuilder() {
        return this.vmBuilder;
    }

    public CloudletBuilder getCloudletBuilder() {
        return this.cloudletBuilder;
    }

    public DatacenterBroker getBroker() {
        return this.broker;
    }
}

