/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelFull;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.builders.BrokerBuilderDecorator;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventListener;

public class CloudletBuilder
extends Builder {
    private long length = 10000L;
    private long outputSize = 300L;
    private long fileSize = 300L;
    private int pes = 1;
    private Vm vm = Vm.NULL;
    private UtilizationModel utilizationModelRam;
    private UtilizationModel utilizationModelCpu;
    private UtilizationModel utilizationModelBw;
    private final List<Cloudlet> cloudlets;
    private int numberOfCreatedCloudlets;
    private final BrokerBuilderDecorator brokerBuilder;
    private final DatacenterBrokerSimple broker;
    private EventListener<CloudletVmEventInfo> onCloudletFinishEventListener = EventListener.NULL;
    private List<String> requiredFiles;

    public CloudletBuilder(BrokerBuilderDecorator brokerBuilder, DatacenterBrokerSimple broker) {
        if (Objects.isNull(brokerBuilder)) {
            throw new RuntimeException("The brokerBuilder parameter cannot be null.");
        }
        if (Objects.isNull(broker)) {
            throw new RuntimeException("The broker parameter cannot be null.");
        }
        this.brokerBuilder = brokerBuilder;
        this.setUtilizationModelCpuRamAndBw(new UtilizationModelFull());
        this.broker = broker;
        this.cloudlets = new ArrayList<Cloudlet>();
        this.requiredFiles = new ArrayList<String>();
        this.numberOfCreatedCloudlets = 0;
    }

    public final CloudletBuilder setUtilizationModelCpuRamAndBw(UtilizationModel utilizationModel) {
        if (!Objects.isNull(utilizationModel)) {
            this.utilizationModelCpu = utilizationModel;
            this.utilizationModelRam = utilizationModel;
            this.utilizationModelBw = utilizationModel;
        }
        return this;
    }

    public CloudletBuilder setVm(Vm defaultVm) {
        this.vm = defaultVm;
        return this;
    }

    public CloudletBuilder setFileSize(long defaultFileSize) {
        this.fileSize = defaultFileSize;
        return this;
    }

    public CloudletBuilder setRequiredFiles(List<String> requiredFiles) {
        this.requiredFiles = requiredFiles;
        return this;
    }

    public List<Cloudlet> getCloudlets() {
        return this.cloudlets;
    }

    public CloudletBuilder setPEs(int defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getOutputSize() {
        return this.outputSize;
    }

    public Cloudlet getCloudletById(int id) {
        return this.broker.getCloudletWaitingList().stream().filter(cloudlet -> cloudlet.getId() == id).findFirst().orElse(Cloudlet.NULL);
    }

    public CloudletBuilder setOutputSize(long defaultOutputSize) {
        this.outputSize = defaultOutputSize;
        return this;
    }

    public int getPes() {
        return this.pes;
    }

    public CloudletBuilder setLength(long defaultLength) {
        this.length = defaultLength;
        return this;
    }

    public CloudletBuilder createAndSubmitOneCloudlet() {
        return this.createAndSubmitCloudlets(1);
    }

    public CloudletBuilder createCloudlets(int amount) {
        this.createCloudletsInternal(amount);
        return this;
    }

    private List<Cloudlet> createCloudletsInternal(int amount) {
        ArrayList<Cloudlet> localList = new ArrayList<Cloudlet>();
        for (int i = 0; i < amount; ++i) {
            int cloudletId;
            ++this.numberOfCreatedCloudlets;
            Cloudlet cloudlet = new CloudletSimple(cloudletId, this.length, this.pes).setFileSize(this.fileSize).setOutputSize(this.outputSize).setUtilizationModelCpu(this.utilizationModelCpu).setUtilizationModelRam(this.utilizationModelRam).setUtilizationModelBw(this.utilizationModelBw).setBroker(this.broker).addOnFinishListener(this.onCloudletFinishEventListener);
            cloudlet.addRequiredFiles(this.requiredFiles);
            localList.add(cloudlet);
        }
        this.cloudlets.addAll(localList);
        return localList;
    }

    public CloudletBuilder createAndSubmitCloudlets(int amount) {
        List<Cloudlet> localList = this.createCloudletsInternal(amount);
        this.broker.submitCloudletList(localList);
        if (this.vm != Vm.NULL) {
            localList.forEach(c -> this.broker.bindCloudletToVm((Cloudlet)c, this.vm));
        }
        return this;
    }

    public CloudletBuilder submitCloudlets() {
        this.broker.submitCloudletList(this.cloudlets);
        return this;
    }

    public BrokerBuilderDecorator getBrokerBuilder() {
        return this.brokerBuilder;
    }

    public EventListener<CloudletVmEventInfo> getOnCloudletFinishEventListener() {
        return this.onCloudletFinishEventListener;
    }

    public CloudletBuilder setOnCloudletFinishEventListener(EventListener<CloudletVmEventInfo> defaultOnCloudletFinishEventListener) {
        this.onCloudletFinishEventListener = defaultOnCloudletFinishEventListener;
        return this;
    }

    public UtilizationModel getUtilizationModelRam() {
        return this.utilizationModelRam;
    }

    public CloudletBuilder setUtilizationModelRam(UtilizationModel utilizationModelRam) {
        if (!Objects.isNull(utilizationModelRam)) {
            this.utilizationModelRam = utilizationModelRam;
        }
        return this;
    }

    public UtilizationModel getUtilizationModelCpu() {
        return this.utilizationModelCpu;
    }

    public CloudletBuilder setUtilizationModelCpu(UtilizationModel utilizationModelCpu) {
        if (!Objects.isNull(utilizationModelCpu)) {
            this.utilizationModelCpu = utilizationModelCpu;
        }
        return this;
    }

    public UtilizationModel getUtilizationModelBw() {
        return this.utilizationModelBw;
    }

    public CloudletBuilder setUtilizationModelBw(UtilizationModel utilizationModelBw) {
        if (!Objects.isNull(utilizationModelBw)) {
            this.utilizationModelBw = utilizationModelBw;
        }
        return this;
    }
}

