/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicySimple;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristicsSimple;
import org.cloudbus.cloudsim.datacenters.DatacenterSimple;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.builders.SimulationScenarioBuilder;

public class DatacenterBuilder
extends Builder {
    public static final String DC_NAME_FORMAT = "Datacenter%d";
    private final SimulationScenarioBuilder scenario;
    private double costPerBwMegabit;
    private double costPerCpuSecond = 3.0;
    private double costPerStorage = 0.001;
    private double costPerMem = 0.05;
    private double schedulingInterval = 1.0;
    private double timezone = 10.0;
    private final List<Datacenter> datacenters;
    private int createdDatacenters;
    private List<FileStorage> storageList;

    public DatacenterBuilder(SimulationScenarioBuilder scenario) {
        this.scenario = scenario;
        this.datacenters = new ArrayList<Datacenter>();
        this.storageList = new ArrayList<FileStorage>();
        this.createdDatacenters = 0;
    }

    public List<Datacenter> getDatacenters() {
        return this.datacenters;
    }

    public Datacenter get(int index) {
        if (index >= 0 && index < this.datacenters.size()) {
            return this.datacenters.get(index);
        }
        return Datacenter.NULL;
    }

    public Host getHostOfDatacenter(int hostIndex, int datacenterIndex) {
        return this.get(datacenterIndex).getHost(hostIndex);
    }

    public Host getFirstHostFromFirstDatacenter() {
        return this.getHostOfDatacenter(0, 0);
    }

    public DatacenterBuilder createDatacenter(List<Host> hosts) {
        Objects.requireNonNull(hosts);
        if (hosts.isEmpty()) {
            throw new IllegalArgumentException("The hosts parameter has to have at least 1 host.");
        }
        DatacenterCharacteristics characteristics = new DatacenterCharacteristicsSimple(hosts).setTimeZone(this.timezone).setCostPerSecond(this.costPerCpuSecond).setCostPerMem(this.costPerMem).setCostPerStorage(this.costPerStorage).setCostPerBw(this.costPerBwMegabit);
        String name = String.format(DC_NAME_FORMAT, this.createdDatacenters++);
        Datacenter datacenter = new DatacenterSimple(this.scenario.getSimulation(), characteristics, new VmAllocationPolicySimple()).setStorageList(this.storageList).setSchedulingInterval(this.schedulingInterval);
        datacenter.setName(name);
        this.datacenters.add(datacenter);
        return this;
    }

    public double getCostPerBwMegabit() {
        return this.costPerBwMegabit;
    }

    public DatacenterBuilder setCostPerBwMegabit(double defaultCostPerBwByte) {
        this.costPerBwMegabit = defaultCostPerBwByte;
        return this;
    }

    public double getCostPerCpuSecond() {
        return this.costPerCpuSecond;
    }

    public DatacenterBuilder setCostPerCpuSecond(double defaultCostPerCpuSecond) {
        this.costPerCpuSecond = defaultCostPerCpuSecond;
        return this;
    }

    public double getCostPerStorage() {
        return this.costPerStorage;
    }

    public DatacenterBuilder setCostPerStorage(double defaultCostPerStorage) {
        this.costPerStorage = defaultCostPerStorage;
        return this;
    }

    public double getCostPerMem() {
        return this.costPerMem;
    }

    public DatacenterBuilder setCostPerMem(double defaultCostPerMem) {
        this.costPerMem = defaultCostPerMem;
        return this;
    }

    public double getTimezone() {
        return this.timezone;
    }

    public DatacenterBuilder setTimezone(double defaultTimezone) {
        this.timezone = defaultTimezone;
        return this;
    }

    public double getSchedulingInterval() {
        return this.schedulingInterval;
    }

    public DatacenterBuilder setSchedulingInterval(double schedulingInterval) {
        this.schedulingInterval = schedulingInterval;
        return this;
    }

    public DatacenterBuilder setStorageList(List<FileStorage> storageList) {
        this.storageList = storageList;
        return this;
    }

    public DatacenterBuilder addStorageToList(FileStorage storage) {
        this.storageList.add(storage);
        return this;
    }
}

