/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerTimeShared;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.builders.PeBuilder;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.HostUpdatesVmsProcessingEventInfo;

public class HostBuilder
extends Builder {
    private double mips = 2000.0;
    private int pes = 1;
    private long bw = 10000L;
    private long storage = 1000000L;
    private long ram = 1024L;
    private Class<? extends VmSchedulerAbstract> vmSchedulerClass = VmSchedulerTimeShared.class;
    private EventListener<HostUpdatesVmsProcessingEventInfo> onUpdateVmsProcessingListener = EventListener.NULL;
    private int numberOfCreatedHosts = 0;
    private final List<Host> hosts = new ArrayList<Host>();

    public List<Host> getHosts() {
        return this.hosts;
    }

    private Host createHost(int id) {
        try {
            List<Pe> peList = new PeBuilder().create(this.pes, this.mips);
            Constructor<? extends VmSchedulerAbstract> cons = this.vmSchedulerClass.getConstructor(new Class[0]);
            Host host = new HostSimple(this.ram, this.bw, this.storage, peList).setRamProvisioner(new ResourceProvisionerSimple()).setBwProvisioner(new ResourceProvisionerSimple()).setVmScheduler(cons.newInstance(new Object[0])).addOnUpdateProcessingListener(this.onUpdateVmsProcessingListener);
            this.hosts.add(host);
            return host;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException("It wasn't possible to instantiate VmScheduler", ex);
        }
    }

    public HostBuilder createOneHost() {
        return this.createHosts(1);
    }

    public HostBuilder createHosts(int amount) {
        this.validateAmount(amount);
        for (int i = 0; i < amount; ++i) {
            this.hosts.add(this.createHost(this.numberOfCreatedHosts++));
        }
        return this;
    }

    public double getMips() {
        return this.mips;
    }

    public HostBuilder setMips(double defaultMIPS) {
        this.mips = defaultMIPS;
        return this;
    }

    public int getPes() {
        return this.pes;
    }

    public HostBuilder setPes(int defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public long getBw() {
        return this.bw;
    }

    public HostBuilder setBw(long defaultBw) {
        this.bw = defaultBw;
        return this;
    }

    public long getStorage() {
        return this.storage;
    }

    public HostBuilder setStorage(long defaultStorage) {
        this.storage = defaultStorage;
        return this;
    }

    public long getRam() {
        return this.ram;
    }

    public HostBuilder setRam(int defaultRam) {
        this.ram = defaultRam;
        return this;
    }

    public Class<? extends VmSchedulerAbstract> getVmSchedulerClass() {
        return this.vmSchedulerClass;
    }

    public HostBuilder setVmSchedulerClass(Class<? extends VmSchedulerAbstract> defaultVmSchedulerClass) {
        this.vmSchedulerClass = defaultVmSchedulerClass;
        return this;
    }

    public EventListener<HostUpdatesVmsProcessingEventInfo> getOnUpdateVmsProcessingListener() {
        return this.onUpdateVmsProcessingListener;
    }

    public HostBuilder setOnUpdateVmsProcessingListener(EventListener<HostUpdatesVmsProcessingEventInfo> onUpdateVmsProcessingListener) {
        this.onUpdateVmsProcessingListener = onUpdateVmsProcessingListener;
        return this;
    }
}

