/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.provisioners.PeProvisioner;
import org.cloudbus.cloudsim.provisioners.PeProvisionerSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.PeSimple;
import org.cloudsimplus.builders.Builder;

public class PeBuilder
extends Builder {
    private Class<? extends PeProvisioner> provisionerClass = PeProvisionerSimple.class;

    public List<Pe> create(double amount, double mipsOfEachPe) {
        try {
            this.validateAmount(amount);
            ArrayList<Pe> peList = new ArrayList<Pe>();
            Constructor<? extends PeProvisioner> cons = this.provisionerClass.getConstructor(new Class[0]);
            int i = 0;
            while ((double)i < amount) {
                peList.add(new PeSimple(mipsOfEachPe, cons.newInstance(new Object[0])));
                ++i;
            }
            return peList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new RuntimeException("It wasn't possible to instantiate a list of Pe", ex);
        }
    }

    public Class<? extends PeProvisioner> getProvisionerClass() {
        return this.provisionerClass;
    }

    public PeBuilder setProvisioner(Class<? extends PeProvisioner> defaultProvisioner) {
        this.provisionerClass = defaultProvisioner;
        return this;
    }
}

