/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;

public class VmBuilder {
    private Supplier<CloudletScheduler> cloudletSchedulerSupplier;
    private long size = 10000L;
    private long ram = 512L;
    private double mips = 1000.0;
    private long bw = 1000L;
    private int pes = 1;
    private int numberOfCreatedVms;
    private final DatacenterBrokerSimple broker;
    private EventListener<VmHostEventInfo> onHostAllocationListener;
    private EventListener<VmHostEventInfo> onHostDeallocationListener;
    private EventListener<VmDatacenterEventInfo> onVmCreationFailureListener;
    private EventListener<VmHostEventInfo> onUpdateVmProcessingListener;

    public VmBuilder(DatacenterBrokerSimple broker) {
        if (Objects.isNull(broker)) {
            throw new RuntimeException("The broker parameter cannot be null.");
        }
        this.broker = broker;
        this.numberOfCreatedVms = 0;
        this.onHostAllocationListener = EventListener.NULL;
        this.onHostDeallocationListener = EventListener.NULL;
        this.onVmCreationFailureListener = EventListener.NULL;
        this.onUpdateVmProcessingListener = EventListener.NULL;
        this.cloudletSchedulerSupplier = () -> CloudletScheduler.NULL;
    }

    public VmBuilder setOnHostDeallocationListener(EventListener<VmHostEventInfo> onHostDeallocationListener) {
        this.onHostDeallocationListener = onHostDeallocationListener;
        return this;
    }

    public VmBuilder setMips(double defaultMIPS) {
        this.mips = defaultMIPS;
        return this;
    }

    public VmBuilder setBw(long defaultBW) {
        this.bw = defaultBW;
        return this;
    }

    public VmBuilder setRam(int defaultRAM) {
        this.ram = defaultRAM;
        return this;
    }

    public VmBuilder setOnHostAllocationListener(EventListener<VmHostEventInfo> onHostAllocationListener) {
        this.onHostAllocationListener = onHostAllocationListener;
        return this;
    }

    public VmBuilder setSize(long defaultSize) {
        this.size = defaultSize;
        return this;
    }

    public VmBuilder setOnVmCreationFilatureListenerForAllVms(EventListener<VmDatacenterEventInfo> onVmCreationFailureListener) {
        this.onVmCreationFailureListener = onVmCreationFailureListener;
        return this;
    }

    public VmBuilder createAndSubmitOneVm() {
        return this.createAndSubmitVms(1);
    }

    public VmBuilder createAndSubmitVms(int amount) {
        ArrayList<Vm> vms = new ArrayList<Vm>();
        for (int i = 0; i < amount; ++i) {
            Vm vm = new VmSimple(this.numberOfCreatedVms++, this.mips, (long)this.pes).setRam(this.ram).setBw(this.bw).setSize(this.size).setCloudletScheduler(this.cloudletSchedulerSupplier.get()).setBroker(this.broker).addOnHostAllocationListener(this.onHostAllocationListener).addOnHostDeallocationListener(this.onHostDeallocationListener).addOnCreationFailureListener(this.onVmCreationFailureListener).addOnUpdateProcessingListener(this.onUpdateVmProcessingListener);
            vms.add(vm);
        }
        this.broker.submitVmList(vms);
        return this;
    }

    public long getBw() {
        return this.bw;
    }

    public VmBuilder setPes(int defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public Vm getVmById(int id) {
        return this.broker.getVmWaitingList().stream().filter(vm -> vm.getId() == id).findFirst().orElse(Vm.NULL);
    }

    public long getSize() {
        return this.size;
    }

    public List<Vm> getVms() {
        return this.broker.getVmWaitingList();
    }

    public long getRam() {
        return this.ram;
    }

    public double getMips() {
        return this.mips;
    }

    public int getPes() {
        return this.pes;
    }

    public VmBuilder setCloudletSchedulerSupplier(Supplier<CloudletScheduler> cloudletSchedulerSupplier) {
        this.cloudletSchedulerSupplier = cloudletSchedulerSupplier;
        return this;
    }

    public EventListener<VmHostEventInfo> getOnUpdateVmProcessingListener() {
        return this.onUpdateVmProcessingListener;
    }

    public VmBuilder setOnUpdateVmProcessingListener(EventListener<VmHostEventInfo> onUpdateVmProcessing) {
        if (!Objects.isNull(onUpdateVmProcessing)) {
            this.onUpdateVmProcessingListener = onUpdateVmProcessing;
        }
        return this;
    }
}

