/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.util.Log;
import org.cloudsimplus.builders.tables.TableBuilder;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class AbstractTableBuilder
implements TableBuilder {
    private final List<TableColumn> columns = new ArrayList<TableColumn>();
    private String title;
    private final List<List<Object>> rows = new ArrayList<List<Object>>();
    private String columnSeparator;

    public AbstractTableBuilder() {
        this("");
    }

    public AbstractTableBuilder(String title) {
        this.setTitle(title);
    }

    @Override
    public List<TableColumn> getColumns() {
        return this.columns;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public final TableBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    @Override
    public final TableBuilder setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    protected List<List<Object>> getRows() {
        return this.rows;
    }

    @Override
    public List<Object> newRow() {
        ArrayList<Object> row = new ArrayList<Object>();
        this.rows.add(row);
        return row;
    }

    private boolean isThereAnySubtitledColumn() {
        return this.columns.stream().anyMatch(col -> !col.getSubTitle().trim().isEmpty());
    }

    private void printRow(List<Object> row) {
        this.printRowOpening();
        List cols = this.columns.stream().limit(Math.min(this.columns.size(), row.size())).collect(Collectors.toList());
        int i = 0;
        for (TableColumn col : cols) {
            Log.print(col.generateData(row.get(i++)));
        }
        this.printRowClosing();
    }

    @Override
    public void print() {
        this.printTableOpening();
        this.printTitle();
        this.printColumnHeaders();
        this.rows.forEach(this::printRow);
        this.printTableClosing();
    }

    protected void printColumnHeaders() {
        this.printRowOpening();
        this.columns.forEach(col -> Log.print(col.generateTitleHeader()));
        this.printRowClosing();
        if (this.isThereAnySubtitledColumn()) {
            this.printRowOpening();
            this.columns.forEach(col -> Log.print(col.generateSubtitleHeader()));
            this.printRowClosing();
        }
    }

    protected abstract void printTableOpening();

    protected abstract void printTitle();

    protected abstract void printRowOpening();

    protected abstract void printRowClosing();

    protected abstract void printTableClosing();

    @Override
    public final TableBuilder addColumnList(String ... columnTitles) {
        for (String column : columnTitles) {
            this.addColumn(column);
        }
        return this;
    }

    @Override
    public final TableColumn addColumn(String columnTitle) {
        return this.addColumn(this.getColumns().size(), columnTitle);
    }

    @Override
    public final TableColumn addColumn(String columnTitle, String columnSubTitle) {
        return this.addColumn(columnTitle).setSubTitle(columnSubTitle);
    }

    @Override
    public final TableColumn addColumn(int index, TableColumn column) {
        this.columns.add(index, column);
        return column;
    }

    @Override
    public final TableColumn addColumn(TableColumn column) {
        return this.addColumn(this.columns.size(), column);
    }
}

