/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudsimplus.builders.tables.TableBuilder;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.builders.tables.TextTableBuilder;

public class CloudletsTableBuilder {
    private static final String TIME_FORMAT = "%d";
    private static final String SECONDS = "Seconds";
    private static final String CPU_CORES = "CPU cores";
    private TableBuilder table;
    private List<? extends Cloudlet> cloudletList;
    private Map<TableColumn, Function<Cloudlet, Object>> columnsDataFunctions;

    public CloudletsTableBuilder(List<? extends Cloudlet> list) {
        this(list, new TextTableBuilder());
    }

    public CloudletsTableBuilder(List<? extends Cloudlet> list, TableBuilder table) {
        Objects.requireNonNull(list);
        this.setTable(table);
        this.setCloudletList(list);
        this.columnsDataFunctions = new HashMap<TableColumn, Function<Cloudlet, Object>>();
        this.createTableColumns();
    }

    public CloudletsTableBuilder setTitle(String title) {
        Objects.requireNonNull(title);
        this.table.setTitle(title);
        return this;
    }

    public void build() {
        if (this.table.getTitle().isEmpty()) {
            this.table.setTitle("SIMULATION RESULTS");
        }
        this.cloudletList.forEach(cloudlet -> this.addDataToRow((Cloudlet)cloudlet, this.table.newRow()));
        this.table.print();
    }

    public CloudletsTableBuilder addColumn(TableColumn col, Function<Cloudlet, Object> dataFunction) {
        return this.addColumn(this.table.getColumns().size(), col, dataFunction);
    }

    public CloudletsTableBuilder addColumn(int index, TableColumn col, Function<Cloudlet, Object> dataFunction) {
        Objects.requireNonNull(col);
        Objects.requireNonNull(dataFunction);
        col.setTable(this.table);
        this.table.addColumn(index, col);
        this.columnsDataFunctions.put(col, dataFunction);
        return this;
    }

    private void createTableColumns() {
        String ID = "ID";
        this.columnsDataFunctions.put(this.table.addColumn("Cloudlet", "ID"), c -> c.getId());
        this.columnsDataFunctions.put(this.table.addColumn("Status "), c -> c.getStatus().name());
        this.columnsDataFunctions.put(this.table.addColumn("DC", "ID"), c -> c.getVm().getHost().getDatacenter().getId());
        this.columnsDataFunctions.put(this.table.addColumn("Host", "ID"), c -> c.getVm().getHost().getId());
        this.columnsDataFunctions.put(this.table.addColumn("Host PEs ", CPU_CORES), c -> c.getVm().getHost().getNumberOfWorkingPes());
        this.columnsDataFunctions.put(this.table.addColumn("VM", "ID"), c -> c.getVm().getId());
        this.columnsDataFunctions.put(this.table.addColumn("VM PEs   ", CPU_CORES), c -> c.getVm().getNumberOfPes());
        this.columnsDataFunctions.put(this.table.addColumn("CloudletLen", "MI"), c -> c.getLength());
        this.columnsDataFunctions.put(this.table.addColumn("CloudletPEs", CPU_CORES), c -> c.getNumberOfPes());
        TableColumn col = this.table.addColumn("StartTime", SECONDS).setFormat(TIME_FORMAT);
        this.columnsDataFunctions.put(col, c -> (long)c.getExecStartTime());
        col = this.table.addColumn("FinishTime", SECONDS).setFormat(TIME_FORMAT);
        this.columnsDataFunctions.put(col, c -> (long)c.getFinishTime());
        col = this.table.addColumn("ExecTime", SECONDS).setFormat(TIME_FORMAT);
        this.columnsDataFunctions.put(col, c -> (long)Math.ceil(c.getActualCpuTime()));
    }

    protected void addDataToRow(Cloudlet cloudlet, List<Object> row) {
        this.table.getColumns().stream().forEach(col -> row.add(this.columnsDataFunctions.get(col).apply(cloudlet)));
    }

    private CloudletsTableBuilder setTable(TableBuilder table) {
        Objects.requireNonNull(table);
        this.table = table;
        return this;
    }

    protected final CloudletsTableBuilder setCloudletList(List<? extends Cloudlet> cloudletList) {
        Objects.requireNonNull(cloudletList);
        this.cloudletList = cloudletList;
        return this;
    }

    protected TableBuilder getTable() {
        return this.table;
    }
}

