/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudbus.cloudsim.util.Log;
import org.cloudsimplus.builders.tables.AbstractTableBuilder;
import org.cloudsimplus.builders.tables.HtmlTableColumn;
import org.cloudsimplus.builders.tables.TableColumn;

public class HtmlTableBuilder
extends AbstractTableBuilder {
    public HtmlTableBuilder() {
    }

    public HtmlTableBuilder(String title) {
        super(title);
    }

    @Override
    protected void printTableOpening() {
        Log.printLine("\n<table>");
    }

    @Override
    protected void printTitle() {
        Log.printFormatted("  <caption>%s</caption>\n", this.getTitle());
    }

    @Override
    protected void printRowOpening() {
        Log.printLine("  <tr>");
    }

    @Override
    protected void printRowClosing() {
        Log.printLine("\n  </tr>");
    }

    @Override
    protected void printTableClosing() {
        Log.printLine("</table>\n");
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        HtmlTableColumn col = new HtmlTableColumn(this, columnTitle);
        this.getColumns().add(index, col);
        return col;
    }
}

