/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudsimplus.builders.tables.AbstractTableColumn;
import org.cloudsimplus.builders.tables.TableBuilder;

public class HtmlTableColumn
extends AbstractTableColumn {
    public HtmlTableColumn(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public HtmlTableColumn(String title) {
        this(null, title, "");
    }

    public HtmlTableColumn(TableBuilder table, String title) {
        super(table, title);
    }

    public HtmlTableColumn(TableBuilder table, String title, String subTitle) {
        super(table, title, subTitle);
    }

    private String identLine(int columnIndex) {
        return columnIndex == 0 ? "    " : "";
    }

    @Override
    protected String generateHeader(String str) {
        int index = this.getTable().getColumns().indexOf(this);
        return String.format("%s<th>%s</th>", this.identLine(index), str);
    }

    @Override
    public String generateData(Object data) {
        int index = this.getTable().getColumns().indexOf(this);
        return String.format("%s<td>%s</td>", this.identLine(index), super.generateData(data));
    }
}

