/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.util.Log;
import org.cloudsimplus.builders.tables.CsvTableBuilder;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.builders.tables.TextTableColumn;

public class TextTableBuilder
extends CsvTableBuilder {
    public TextTableBuilder() {
        this("");
    }

    public TextTableBuilder(String title) {
        super(title);
        this.setColumnSeparator("|");
    }

    @Override
    public void printTitle() {
        if (!this.getTitle().trim().isEmpty()) {
            Log.print(this.getCentralizedString(this.getTitle()));
        }
    }

    @Override
    public void printTableOpening() {
        Log.printLine();
    }

    @Override
    protected void printColumnHeaders() {
        super.printColumnHeaders();
        Log.printFormatted("%s\n", this.createHorizontalLine());
    }

    @Override
    public void printTableClosing() {
        Log.printFormatted("%s\n", this.createHorizontalLine());
    }

    private String getCentralizedString(String str) {
        int identationLength = (this.getLengthOfColumnHeadersRow() - str.length()) / 2;
        return String.format("\n%s%s\n", StringUtils.repeat((String)" ", (int)identationLength), str);
    }

    private String createHorizontalLine() {
        return this.stringRepeat(this.getLineSeparator(), this.getLengthOfColumnHeadersRow());
    }

    private String stringRepeat(String str, int timesToRepeat) {
        return new String(new char[timesToRepeat]).replace("\u0000", str);
    }

    private int getLengthOfColumnHeadersRow() {
        return this.getColumns().stream().mapToInt(col -> col.generateTitleHeader().length()).sum();
    }

    @Override
    public String getLineSeparator() {
        return "-";
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        return this.addColumn(new TextTableColumn(this, columnTitle));
    }
}

