/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.faultinjection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.Identificable;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.util.Log;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.faultinjection.VmCloner;

public class HostFaultInjection
extends CloudSimEntity {
    private static final int MAX_VM_RECOVERY_TIME_SECS = 450;
    private Host lastFailedHost;
    private int lastNumberOfFailedPes;
    private Datacenter datacenter;
    private ContinuousDistribution random;
    private Map<DatacenterBroker, VmCloner> vmClonerMap;
    private ContinuousDistribution faultArrivalTimesGeneratorInHours;
    private int numberOfHostFaults;
    private final Map<Vm, Double> vmRecoveryTimeSecsMap;
    private final Map<Host, List<Double>> hostFaultsTimeSecsMap;
    private final Map<DatacenterBroker, Integer> faultsOfAllVmsByBroker;
    private double maxTimeToGenerateFailureInHours;

    public HostFaultInjection(Datacenter datacenter, ContinuousDistribution faultArrivalTimesGeneratorInHours) {
        super(datacenter.getSimulation());
        this.setDatacenter(datacenter);
        this.lastFailedHost = Host.NULL;
        this.faultArrivalTimesGeneratorInHours = faultArrivalTimesGeneratorInHours;
        this.random = new UniformDistr(faultArrivalTimesGeneratorInHours.getSeed() + 1L);
        this.vmRecoveryTimeSecsMap = new HashMap<Vm, Double>();
        this.hostFaultsTimeSecsMap = new HashMap<Host, List<Double>>();
        this.faultsOfAllVmsByBroker = new HashMap<DatacenterBroker, Integer>();
        this.vmClonerMap = new HashMap<DatacenterBroker, VmCloner>();
        this.maxTimeToGenerateFailureInHours = Double.MAX_VALUE;
    }

    @Override
    protected void startEntity() {
        this.scheduleFaultInjection();
    }

    private void scheduleFaultInjection() {
        long numOfOtherEvents = this.getSimulation().getNumberOfFutureEvents(evt -> evt.getTag() != 49);
        if (numOfOtherEvents > 0L || this.getSimulation().clock() < this.getMaxTimeToGenerateFailureInSeconds()) {
            this.schedule(this.getId(), this.getTimeDelayForNextFault(), 49);
        }
    }

    private double getTimeDelayForNextFault() {
        return this.faultArrivalTimesGeneratorInHours.sample() * 3600.0;
    }

    @Override
    public void processEvent(SimEvent ev) {
        switch (ev.getTag()) {
            case 49: {
                this.generateHostFault();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHostFault() {
        try {
            Host failedHost = this.getRandomHost();
            if (Host.NULL == failedHost || failedHost.getVmList().isEmpty()) {
                return;
            }
            this.lastFailedHost = failedHost;
            if (Host.NULL.equals(this.lastFailedHost)) {
                return;
            }
            ++this.numberOfHostFaults;
            this.registerHostFaultTime();
            long previousNumOfWorkingPes = this.lastFailedHost.getNumberOfWorkingPes();
            this.lastNumberOfFailedPes = this.generateHostPesFaults();
            long hostWorkingPes = this.lastFailedHost.getNumberOfWorkingPes();
            long vmsRequiredPes = this.getPesSumOfWorkingVms();
            Log.printFormattedLine("%.2f: %s: Generated %d PEs failures from %d previously working PEs for %s at minute %.2f", this.getSimulation().clock(), this.getClass().getSimpleName(), this.lastNumberOfFailedPes, previousNumOfWorkingPes, this.lastFailedHost, this.getSimulation().clock() / 60.0);
            Log.printFormattedLine("\tCurrent Working PEs: %d | Number of VMs: %d", hostWorkingPes, this.lastFailedHost.getVmList().size());
            if (!this.lastFailedHost.getVmList().isEmpty()) {
                Log.printFormattedLine("\tVMs required PEs: %d", vmsRequiredPes);
            }
            if (hostWorkingPes == 0L) {
                this.setAllVmsToFailed();
            } else if (hostWorkingPes >= vmsRequiredPes) {
                this.logNoVmFault();
            } else {
                this.deallocateFailedHostPesFromVms();
            }
        }
        finally {
            this.scheduleFaultInjection();
        }
    }

    private void registerHostFaultTime() {
        this.hostFaultsTimeSecsMap.computeIfAbsent(this.lastFailedHost, h -> new ArrayList()).add(this.getSimulation().clock());
    }

    private Host getRandomHost() {
        if (this.datacenter.getHostList().isEmpty()) {
            return Host.NULL;
        }
        int i = (int)(this.random.sample() * (double)this.datacenter.getHostList().size());
        Host h = this.datacenter.getHost(i);
        return h;
    }

    private void setAllVmsToFailed() {
        Log.printFormattedLine("\tAll the %d PEs failed, affecting all its %d VMs.\n", this.lastFailedHost.getNumberOfPes(), this.lastFailedHost.getVmList().size());
        this.setVmListToFailed(this.lastFailedHost.getVmList());
    }

    private void logNoVmFault() {
        int vmsRequiredPes = (int)this.getPesSumOfWorkingVms();
        if (this.lastFailedHost.getVmList().isEmpty()) {
            Log.printLine("\tThere aren't VMs running on the failed Host.");
            return;
        }
        Log.printFormattedLine("\tNumber of failed PEs is less than PEs required by all its %d VMs, thus it doesn't affect any VM.", this.lastFailedHost.getVmList().size());
        Log.printFormattedLine("\tTotal PEs: %d | Total Failed PEs: %d | Working PEs: %d | Current PEs required by VMs: %d.\n", this.lastFailedHost.getNumberOfPes(), this.lastFailedHost.getNumberOfFailedPes(), this.lastFailedHost.getNumberOfWorkingPes(), vmsRequiredPes);
    }

    private void deallocateFailedHostPesFromVms() {
        Log.printFormattedLine("\t%d PEs just failed. There is a total of %d working PEs.", this.lastNumberOfFailedPes, this.lastFailedHost.getNumberOfWorkingPes());
        this.cyclicallyRemoveFailedHostPesFromVms();
        Log.printLine();
        List<Vm> vmsWithoutPes = this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() == 0L).collect(Collectors.toList());
        this.setVmListToFailed(vmsWithoutPes);
    }

    private void cyclicallyRemoveFailedHostPesFromVms() {
        int failedPesToRemoveFromVms = this.numberOfFailedPesToRemoveFromVms();
        List<Vm> vmsWithPes = this.getVmsWithPEsFromFailedHost();
        int affectedVms = Math.min(vmsWithPes.size(), failedPesToRemoveFromVms);
        Log.printFormattedLine("\t%d VMs affected from a total of %d. %d PEs are going to be removed from them.", affectedVms, this.lastFailedHost.getVmList().size(), failedPesToRemoveFromVms);
        int i = 0;
        while (!vmsWithPes.isEmpty() && failedPesToRemoveFromVms-- > 0) {
            Vm vm = vmsWithPes.get(i %= vmsWithPes.size());
            this.lastFailedHost.getVmScheduler().deallocatePesFromVm(vm, 1);
            vm.getCloudletScheduler().deallocatePesFromVm(vm, 1);
            vm.getProcessor().deallocateAndRemoveResource(1L);
            Log.printFormattedLine("\tRemoving 1 PE from VM %d due to Host PE failure. New VM PEs Number: %d\n", vm.getId(), vm.getNumberOfPes());
            ++i;
            vmsWithPes = this.getVmsWithPEsFromFailedHost();
        }
    }

    private int numberOfFailedPesToRemoveFromVms() {
        int hostWorkingPes = (int)this.lastFailedHost.getNumberOfWorkingPes();
        int vmsRequiredPes = (int)this.getPesSumOfWorkingVms();
        int failedPesToRemoveFromVms = vmsRequiredPes - hostWorkingPes;
        return failedPesToRemoveFromVms;
    }

    private List<Vm> getVmsWithPEsFromFailedHost() {
        return this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() > 0L).collect(Collectors.toList());
    }

    private void setVmListToFailed(List<Vm> vms) {
        Map<DatacenterBroker, Vm> lastVmFailedByBroker = this.getLastFailedVmByBroker(vms);
        vms.forEach(this::setVmToFailed);
        lastVmFailedByBroker.forEach(this::createVmCloneIfAllVmsDestroyed);
    }

    private Map<DatacenterBroker, Vm> getLastFailedVmByBroker(List<Vm> vmsWithoutPes) {
        Comparator<Vm> comparator = Comparator.comparingInt(Identificable::getId);
        return vmsWithoutPes.stream().collect(Collectors.groupingBy(Vm::getBroker, Collectors.collectingAndThen(Collectors.maxBy(comparator), Optional::get)));
    }

    private void createVmCloneIfAllVmsDestroyed(DatacenterBroker broker, Vm lastVmFailedFromBroker) {
        if (!this.isAllVmsFailed(broker)) {
            return;
        }
        if (!this.isVmClonerSet(broker) || this.getVmCloner(broker).isMaxClonesNumberReached()) {
            this.vmRecoveryTimeSecsMap.put(lastVmFailedFromBroker, -this.getSimulation().clock());
        }
        if (!this.isVmClonerSet(broker)) {
            Log.printFormattedLine("\t# A Vm Cloner was not set for broker %d. So that VM failure will not be recovered.", broker.getId());
            return;
        }
        VmCloner cloner = this.getVmCloner(broker);
        if (cloner.isMaxClonesNumberReached()) {
            Log.printFormattedLine("\t# The maximum allowed number of %d VMs to create has been reached.", cloner.getMaxClonesNumber());
            return;
        }
        this.registerFaultOfAllVms(broker);
        double recoveryTimeSecs = this.getRandomRecoveryTimeForVmInSecs();
        Log.printFormattedLine("\t# Time to recovery from fault by cloning the failed VM: %.2f minutes", recoveryTimeSecs / 60.0);
        Map.Entry<Vm, List<Cloudlet>> entry = cloner.clone(lastVmFailedFromBroker);
        Vm clonedVm = entry.getKey();
        List<Cloudlet> clonedCloudlets = entry.getValue();
        clonedVm.setSubmissionDelay(recoveryTimeSecs);
        clonedVm.addOnHostAllocationListener(evt -> this.vmRecoveryTimeSecsMap.put(evt.getVm(), recoveryTimeSecs));
        broker.submitVm(clonedVm);
        broker.submitCloudletList(clonedCloudlets, recoveryTimeSecs);
    }

    private void setVmToFailed(Vm vm) {
        if (Host.NULL.equals(this.lastFailedHost)) {
            return;
        }
        vm.setFailed(true);
        DatacenterBroker broker = vm.getBroker();
        if (this.isVmClonerSet(broker) && !this.isAllVmsFailed(broker)) {
            Log.printFormattedLine("\n\t\t\t #VM %d destroyed but not cloned, since there are %d VMs for the broker %d yet\n", vm.getId(), this.getRunningVmsNumber(broker), broker.getId());
        }
        this.getSimulation().sendNow(broker.getId(), this.datacenter.getId(), 33, vm);
    }

    private void registerFaultOfAllVms(DatacenterBroker broker) {
        this.faultsOfAllVmsByBroker.merge(broker, 1, (old, inc) -> old + inc);
    }

    private VmCloner getVmCloner(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL);
    }

    private boolean isAllVmsFailed(DatacenterBroker broker) {
        return broker.getVmExecList().stream().allMatch(Vm::isFailed);
    }

    private long getRunningVmsNumber(DatacenterBroker broker) {
        return broker.getVmExecList().stream().filter(vm -> !vm.isFailed()).count();
    }

    private boolean isVmClonerSet(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL) != VmCloner.NULL;
    }

    public int getNumberOfHostFaults() {
        return this.numberOfHostFaults;
    }

    public double availability() {
        return this.availability(null);
    }

    public double availability(DatacenterBroker broker) {
        double mtbf = this.meanTimeBetweenVmFaultsInMinutes(broker);
        if (mtbf == 0.0) {
            return 1.0;
        }
        double mttr = this.meanTimeToRepairVmFaultsInMinutes(broker);
        return mtbf / (mtbf + mttr);
    }

    public long getNumberOfFaults() {
        return this.faultsOfAllVmsByBroker.values().stream().count();
    }

    public long getNumberOfFaults(DatacenterBroker broker) {
        if (broker == null) {
            return this.getNumberOfFaults();
        }
        return this.faultsOfAllVmsByBroker.getOrDefault(broker, 0).intValue();
    }

    private double totalVmsRecoveryTimeInMinutes() {
        return this.totalVmsRecoveryTimeInMinutes(null);
    }

    private double totalVmsRecoveryTimeInMinutes(DatacenterBroker broker) {
        Stream<Double> stream = broker == null ? this.vmRecoveryTimeSecsMap.values().stream() : this.vmRecoveryTimeSecsMap.entrySet().stream().filter(entry -> broker.equals(((Vm)entry.getKey()).getBroker())).map(Map.Entry::getValue);
        double seconds = stream.map(rt -> rt >= 0.0 ? rt : this.getSimulation().clock() - Math.abs(rt)).reduce(0.0, Double::sum);
        return (long)(seconds / 60.0);
    }

    public double meanTimeBetweenHostFaultsInMinutes() {
        List faultTimes = this.hostFaultsTimeSecsMap.values().stream().flatMap(list -> list.stream()).sorted().collect(Collectors.toList());
        if (faultTimes.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        double previous = (Double)faultTimes.get(0);
        for (Double v : faultTimes) {
            sum += v - previous;
            previous = v;
        }
        double seconds = sum / (double)faultTimes.size();
        return (long)(seconds / 60.0);
    }

    public double meanTimeBetweenVmFaultsInMinutes() {
        return this.meanTimeBetweenVmFaultsInMinutes(null);
    }

    public double meanTimeBetweenVmFaultsInMinutes(DatacenterBroker broker) {
        double faultsFromBroker = this.getNumberOfFaults(broker);
        if (faultsFromBroker == 0.0) {
            return 0.0;
        }
        double totalVmsRecoveryTimeInMinutes = this.meanTimeToRepairVmFaultsInMinutes(broker);
        return this.getSimulation().clockInMinutes() - totalVmsRecoveryTimeInMinutes;
    }

    public double meanTimeToRepairVmFaultsInMinutes() {
        return this.meanTimeToRepairVmFaultsInMinutes(null);
    }

    public double meanTimeToRepairVmFaultsInMinutes(DatacenterBroker broker) {
        double faultsFromBroker = this.getNumberOfFaults(broker);
        if (faultsFromBroker == 0.0) {
            return 0.0;
        }
        return this.totalVmsRecoveryTimeInMinutes(broker) / faultsFromBroker;
    }

    private int generateHostPesFaults() {
        return (int)this.lastFailedHost.getWorkingPeList().stream().limit(this.randomNumberOfFailedPes()).peek(pe -> pe.setStatus(Pe.Status.FAILED)).count();
    }

    private long getPesSumOfWorkingVms() {
        return this.lastFailedHost.getVmList().stream().filter(vm -> !vm.isFailed()).mapToLong(vm -> vm.getNumberOfPes()).sum();
    }

    private int randomNumberOfFailedPes() {
        return (int)(this.random.sample() * (double)this.lastFailedHost.getWorkingPeList().size()) + 1;
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    protected final void setDatacenter(Datacenter datacenter) {
        Objects.requireNonNull(datacenter);
        this.datacenter = datacenter;
    }

    public void addVmCloner(DatacenterBroker broker, VmCloner cloner) {
        Objects.requireNonNull(broker);
        Objects.requireNonNull(cloner);
        this.vmClonerMap.put(broker, cloner);
    }

    public Host getLastFailedHost() {
        return this.lastFailedHost;
    }

    @Override
    public void shutdownEntity() {
    }

    public double getRandomRecoveryTimeForVmInSecs() {
        return this.random.sample() * 450.0 + 1.0;
    }

    public double getMaxTimeToGenerateFailureInHours() {
        return this.maxTimeToGenerateFailureInHours;
    }

    private double getMaxTimeToGenerateFailureInSeconds() {
        return this.maxTimeToGenerateFailureInHours * 3600.0;
    }

    public void setMaxTimeToGenerateFailureInHours(double maxTimeToGenerateFailureInHours) {
        this.maxTimeToGenerateFailureInHours = maxTimeToGenerateFailureInHours;
    }
}

