/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.heuristics.Heuristic;
import org.cloudsimplus.heuristics.HeuristicSolution;

public class CloudletToVmMappingSolution
implements HeuristicSolution<Map<Cloudlet, Vm>> {
    public static final double MIN_DIFF = 1.0E-4;
    private final Map<Cloudlet, Vm> cloudletVmMap;
    private boolean recomputeCost = true;
    private double lastCost;
    private final Heuristic heuristic;

    public CloudletToVmMappingSolution(Heuristic heuristic) {
        this(heuristic, new HashMap<Cloudlet, Vm>());
    }

    private CloudletToVmMappingSolution(Heuristic heuristic, Map<Cloudlet, Vm> cloudletVmMap) {
        this.heuristic = heuristic;
        this.cloudletVmMap = cloudletVmMap;
    }

    public CloudletToVmMappingSolution(CloudletToVmMappingSolution solution) {
        this(solution.heuristic, new HashMap<Cloudlet, Vm>(solution.cloudletVmMap));
    }

    public void bindCloudletToVm(Cloudlet cloudlet, Vm vm) {
        this.cloudletVmMap.put(cloudlet, vm);
        this.recomputeCost = true;
    }

    @Override
    public Heuristic<HeuristicSolution<Map<Cloudlet, Vm>>> getHeuristic() {
        return this.heuristic;
    }

    @Override
    public double getCost() {
        if (this.recomputeCost) {
            Map<Vm, List<Map.Entry>> cloudletsByVm = this.cloudletVmMap.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue));
            this.lastCost = cloudletsByVm.entrySet().stream().mapToDouble(e -> this.getVmCost((Vm)e.getKey(), (List)e.getValue())).sum();
            this.recomputeCost = false;
        }
        return this.lastCost;
    }

    public double getCost(boolean forceRecompute) {
        this.recomputeCost |= forceRecompute;
        return this.getCost();
    }

    public double getVmCost(Vm vm, List<Map.Entry<Cloudlet, Vm>> listOfCloudletsForVm) {
        long totalCloudletsPes = listOfCloudletsForVm.stream().mapToLong(e -> ((Cloudlet)e.getKey()).getNumberOfPes()).sum();
        return Math.abs(vm.getNumberOfPes() - totalCloudletsPes);
    }

    @Override
    public int compareTo(HeuristicSolution o) {
        double diff = this.getCost() - o.getCost();
        if (Math.abs(diff) <= 1.0E-4) {
            return 0;
        }
        return diff > 0.0 ? -1 : 1;
    }

    @Override
    public Map<Cloudlet, Vm> getResult() {
        return Collections.unmodifiableMap(this.cloudletVmMap);
    }

    protected boolean swapVmsOfTwoMapEntries(Map.Entry<Cloudlet, Vm> ... entries) {
        if (Objects.isNull(entries) || entries.length != 2 || Objects.isNull(entries[0]) || Objects.isNull(entries[1])) {
            return false;
        }
        Vm vm1 = entries[0].getValue();
        Vm vm2 = entries[1].getValue();
        entries[0].setValue(vm2);
        entries[1].setValue(vm1);
        return true;
    }

    boolean swapVmsOfTwoRandomSelectedMapEntries() {
        return this.swapVmsOfTwoMapEntries(this.getRandomMapEntries());
    }

    /*
     * Exception decompiling
     */
    protected Map.Entry<Cloudlet, Vm>[] getRandomMapEntries() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

