/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.slametrics;

import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudsimplus.slametrics.SlaMetric;

public class SlaContract {
    private static final String AVAILABILITY = "Availability";
    private static final String TASK_COMPLETION_TIME = "TaskTimeCompletion";
    private static final String CPU_UTILIZATION = "CpuUtilization";
    private static final String WAIT_TIME = "WaitTime";
    private static final String PRICE = "Price";
    private static final String FAULT_TOLERANCE_LEVEL = "FaultToleranceLevel";
    private List<SlaMetric> metrics = new ArrayList<SlaMetric>();

    public static SlaContract getInstance(String jsonFilePath) throws FileNotFoundException {
        return (SlaContract)new Gson().fromJson((Reader)new FileReader(jsonFilePath), SlaContract.class);
    }

    public static SlaContract getInstanceFromResourcesDir(Class klass, String jsonFilePath) throws FileNotFoundException {
        return SlaContract.getInstance(ResourceLoader.getResourcePath(klass, jsonFilePath));
    }

    public List<SlaMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<SlaMetric> metrics) {
        this.metrics = metrics == null ? new ArrayList() : metrics;
    }

    private SlaMetric getSlaMetric(String metricName) {
        return this.metrics.stream().filter(m -> metricName.equals(m.getName())).findFirst().orElse(SlaMetric.NULL);
    }

    public SlaMetric getAvailabilityMetric() {
        return this.getSlaMetric(AVAILABILITY);
    }

    public SlaMetric getCpuUtilizationMetric() {
        return this.getSlaMetric(CPU_UTILIZATION);
    }

    public SlaMetric getPriceMetric() {
        return this.getSlaMetric(PRICE);
    }

    public SlaMetric getWaitTimeMetric() {
        return this.getSlaMetric(WAIT_TIME);
    }

    public SlaMetric getTaskCompletionTimeMetric() {
        return this.getSlaMetric(TASK_COMPLETION_TIME);
    }

    public SlaMetric getFaultToleranceLevel() {
        return this.getSlaMetric(FAULT_TOLERANCE_LEVEL);
    }

    public double getMaxPrice() {
        return this.getPriceMetric().getMaxDimension().getValue();
    }

    public double getExpectedMaxPriceForSingleVm() {
        return this.getMaxPrice() / this.getFaultToleranceLevel().getMinDimension().getValue();
    }

    public int getMinFaultToleranceLevel() {
        return (int)Math.floor(this.getFaultToleranceLevel().getMinDimension().getValue());
    }

    public String toString() {
        return this.metrics.toString();
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = "/Users/raysaoliveira/Desktop/Mestrado/cloudsim-plus/cloudsim-plus-testbeds/src/main/resources/SlaCustomer1.json";
        SlaContract contract = SlaContract.getInstance("/Users/raysaoliveira/Desktop/Mestrado/cloudsim-plus/cloudsim-plus-testbeds/src/main/resources/SlaCustomer1.json");
        System.out.println("Contract file: /Users/raysaoliveira/Desktop/Mestrado/cloudsim-plus/cloudsim-plus-testbeds/src/main/resources/SlaCustomer1.json");
        System.out.println(contract);
        System.out.println("Minimum Price Metric Value: " + contract.getPriceMetric().getMinDimension());
        System.out.println("Maximum Price Metric Value: " + contract.getPriceMetric().getMaxDimension());
        System.out.println("Maximum CPU Metric Value: " + contract.getCpuUtilizationMetric().getMaxDimension());
    }
}

