/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vmtemplates;

import com.google.gson.Gson;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cloudbus.cloudsim.util.ResourceLoader;

public class AwsEc2Template
implements Comparable<AwsEc2Template> {
    public static final AwsEc2Template NULL = new AwsEc2Template();
    private String name;
    private Path path;
    private int cpus;
    private int memoryInMB;
    private double pricePerHour;

    public AwsEc2Template() {
    }

    public AwsEc2Template(AwsEc2Template source) {
        this.name = source.name;
        this.cpus = source.cpus;
        this.memoryInMB = source.memoryInMB;
        this.pricePerHour = source.pricePerHour;
        this.path = Paths.get(source.path.toUri());
    }

    public static AwsEc2Template getInstance(String jsonTemplateFilePath) throws FileNotFoundException {
        FileReader fileReader = new FileReader(jsonTemplateFilePath);
        AwsEc2Template template = (AwsEc2Template)new Gson().fromJson((Reader)fileReader, AwsEc2Template.class);
        template.path = Paths.get(jsonTemplateFilePath, new String[0]);
        return template;
    }

    public static AwsEc2Template getInstanceFromResourcesDir(String jsonFilePath) throws FileNotFoundException {
        return AwsEc2Template.getInstance(ResourceLoader.getResourcePath(AwsEc2Template.class, jsonFilePath));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public int getMemoryInMB() {
        return this.memoryInMB;
    }

    public void setMemoryInMB(int memoryInMB) {
        this.memoryInMB = memoryInMB;
    }

    public double getPricePerHour() {
        return this.pricePerHour;
    }

    public void setPricePerHour(double pricePerHour) {
        this.pricePerHour = pricePerHour;
    }

    public String toString() {
        return "AwsEc2Template {name = " + this.name + ",  cpus = " + this.cpus + ",  memoryInMB = " + this.memoryInMB + ",  pricePerHour = " + this.pricePerHour + '}';
    }

    public static void main(String[] args) throws FileNotFoundException {
        AwsEc2Template template = AwsEc2Template.getInstanceFromResourcesDir("vmtemplates/aws/t2.nano.json");
        System.out.println(template);
    }

    public String getFilePath() {
        return this.path.toAbsolutePath().toString();
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    @Override
    public int compareTo(AwsEc2Template o) {
        int comparison = Double.compare(this.cpus, o.cpus);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.memoryInMB, o.memoryInMB);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.pricePerHour, o.pricePerHour);
        return comparison;
    }
}

